"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProductCard = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react_router_helpers = require("../../../shared/react_router_helpers");
var _telemetry = require("../../../shared/telemetry");
require("./product_card.scss");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ProductCard = ({
  cta,
  description,
  emptyCta = false,
  features,
  icon,
  productId,
  name,
  resourceLinks,
  url
}) => {
  const {
    sendEnterpriseSearchTelemetry
  } = (0, _kea.useActions)(_telemetry.TelemetryLogic);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    paddingSize: "l",
    "data-test-subj": `${productId}ProductCard`,
    className: "productCard"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    "data-test-subj": "productCard-icon"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    size: "xl",
    type: icon
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "productCard-details"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", null, name)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, description), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement("div", null, emptyCta ? /*#__PURE__*/_react.default.createElement(_react_router_helpers.EuiButtonTo, {
    to: url,
    shouldNotCreateHref: true,
    onClick: () => sendEnterpriseSearchTelemetry({
      action: 'clicked',
      metric: (0, _lodash.snakeCase)(productId)
    })
  }, cta) : /*#__PURE__*/_react.default.createElement(_react_router_helpers.EuiButtonEmptyTo, {
    flush: "both",
    to: url,
    shouldNotCreateHref: true,
    onClick: () => sendEnterpriseSearchTelemetry({
      action: 'clicked',
      metric: (0, _lodash.snakeCase)(productId)
    })
  }, cta))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "productCard-features"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiListGroup, {
    flush: true,
    className: "productCard-features"
  }, features.map((item, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiListGroupItem, {
    key: index,
    size: "s",
    label: item,
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      color: "success",
      type: "checkInCircleFilled"
    })
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h4", {
    "data-test-subj": "productCard-resources"
  }, _i18n.i18n.translate('xpack.enterpriseSearch.productCard.resourcesTitle', {
    defaultMessage: 'Resources'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m",
    "data-test-subj": "productCard-resourceLinks"
  }, resourceLinks.map((resource, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: index,
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: resource.to,
    target: "_blank",
    external: true
  }, resource.label)))))));
};
exports.ProductCard = ProductCard;