"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getContentExtractionDisabled = getContentExtractionDisabled;
exports.getIngestionMethod = getIngestionMethod;
exports.getIngestionStatus = getIngestionStatus;
exports.getLastUpdated = getLastUpdated;
exports.indexToViewIndex = indexToViewIndex;
exports.ingestionMethodToText = ingestionMethodToText;
exports.isApiIndex = isApiIndex;
exports.isApiViewIndex = isApiViewIndex;
exports.isConnectorIndex = isConnectorIndex;
exports.isConnectorViewIndex = isConnectorViewIndex;
exports.isCrawlerIndex = isCrawlerIndex;
exports.isCrawlerViewIndex = isCrawlerViewIndex;
var _moment = _interopRequireDefault(require("moment"));
var _i18n = require("@kbn/i18n");
var _constants = require("../../../../common/constants");
var _connectors = require("../../../../common/types/connectors");
var _types = require("../types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function isConnectorIndex(index) {
  const connectorIndex = index;
  return !!(connectorIndex !== null && connectorIndex !== void 0 && connectorIndex.connector) && connectorIndex.connector.service_type !== _constants.ENTERPRISE_SEARCH_CONNECTOR_CRAWLER_SERVICE_TYPE;
}
function isCrawlerIndex(index) {
  return !!(index !== null && index !== void 0 && index.crawler);
}
function isApiIndex(index) {
  if (!index) {
    return false;
  }
  return !isConnectorIndex(index) && !isCrawlerIndex(index);
}
function isConnectorViewIndex(index) {
  const connectorViewIndex = index;
  return !!(connectorViewIndex !== null && connectorViewIndex !== void 0 && connectorViewIndex.connector) && connectorViewIndex.connector.service_type !== _constants.ENTERPRISE_SEARCH_CONNECTOR_CRAWLER_SERVICE_TYPE;
}
function isCrawlerViewIndex(index) {
  return !!(index !== null && index !== void 0 && index.crawler);
}
function isApiViewIndex(index) {
  return !!index && !isConnectorViewIndex(index) && !isCrawlerViewIndex(index);
}
function getIngestionMethod(index) {
  if (!index) return _types.IngestionMethod.API;
  if (isConnectorIndex(index)) {
    return _types.IngestionMethod.CONNECTOR;
  }
  if (isCrawlerIndex(index)) {
    return _types.IngestionMethod.CRAWLER;
  }
  return _types.IngestionMethod.API;
}
function getIngestionStatus(index) {
  if (!index || isApiIndex(index)) {
    return _types.IngestionStatus.CONNECTED;
  }
  if (isConnectorIndex(index) || isCrawlerIndex(index) && index.connector) {
    if (index.connector.last_seen && (0, _moment.default)(index.connector.last_seen).isBefore((0, _moment.default)().subtract(30, 'minutes'))) {
      return _types.IngestionStatus.ERROR;
    }
    if (index.connector.last_sync_status === _connectors.SyncStatus.ERROR) {
      return _types.IngestionStatus.SYNC_ERROR;
    }
    if (index.connector.status === _connectors.ConnectorStatus.CONNECTED) {
      return _types.IngestionStatus.CONNECTED;
    }
    if (index.connector.status === _connectors.ConnectorStatus.ERROR) {
      return _types.IngestionStatus.ERROR;
    }
    if (index.connector.status === _connectors.ConnectorStatus.CONFIGURED) {
      return _types.IngestionStatus.CONFIGURED;
    }
  }
  return _types.IngestionStatus.INCOMPLETE;
}
function getLastUpdated(index) {
  var _index$connector$last;
  return isConnectorIndex(index) ? (_index$connector$last = index.connector.last_synced) !== null && _index$connector$last !== void 0 ? _index$connector$last : 'never' : null;
}
function getContentExtractionDisabled(index) {
  if (!index) return false;
  if (isConnectorIndex(index)) {
    var _index$connector$conf, _index$connector$conf2;
    const contentExtractionDisabled = (_index$connector$conf = index.connector.configuration) === null || _index$connector$conf === void 0 ? void 0 : (_index$connector$conf2 = _index$connector$conf.use_text_extraction_service) === null || _index$connector$conf2 === void 0 ? void 0 : _index$connector$conf2.value;
    return !!contentExtractionDisabled;
  }
  return false;
}
function indexToViewIndex(index) {
  const extraFields = {
    ingestionMethod: getIngestionMethod(index),
    ingestionStatus: getIngestionStatus(index),
    lastUpdated: getLastUpdated(index)
  };
  if (isConnectorIndex(index)) {
    const connectorResult = {
      ...index,
      ...extraFields
    };
    return connectorResult;
  }
  if (isCrawlerIndex(index)) {
    const crawlerResult = {
      ...index,
      ...extraFields
    };
    return crawlerResult;
  }
  const apiResult = {
    ...index,
    ...extraFields
  };
  return apiResult;
}
function ingestionMethodToText(ingestionMethod) {
  switch (ingestionMethod) {
    case _types.IngestionMethod.CONNECTOR:
      return _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndices.ingestionMethod.connector', {
        defaultMessage: 'Connector'
      });
    case _types.IngestionMethod.CRAWLER:
      return _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndices.ingestionMethod.crawler', {
        defaultMessage: 'Crawler'
      });
    case _types.IngestionMethod.API:
      return _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndices.ingestionMethod.api', {
        defaultMessage: 'API'
      });
    default:
      return ingestionMethod;
  }
}