"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SyncJobEventsPanel = void 0;
var _react = _interopRequireDefault(require("react"));
var _moment = _interopRequireDefault(require("moment"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _connectors = require("../../../../../../common/types/connectors");
var _formatted_date_time = require("../../../../shared/formatted_date_time");
var _flyout_panel = require("./flyout_panel");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SyncJobEventsPanel = ({
  cancelationRequestedAt,
  canceledAt,
  completed,
  lastUpdated,
  syncRequestedAt,
  syncStarted,
  triggerMethod
}) => {
  const events = [{
    date: syncRequestedAt,
    title: triggerMethod === _connectors.TriggerMethod.ON_DEMAND ? _i18n.i18n.translate('xpack.enterpriseSearch.content.index.syncJobs.events.syncRequestedManually', {
      defaultMessage: 'Sync requested manually'
    }) : _i18n.i18n.translate('xpack.enterpriseSearch.content.index.syncJobs.events.syncRequestedScheduled', {
      defaultMessage: 'Sync requested by schedule'
    })
  }, {
    date: syncStarted,
    title: _i18n.i18n.translate('xpack.enterpriseSearch.content.index.syncJobs.events.syncStarted', {
      defaultMessage: 'Sync started'
    })
  }, {
    date: lastUpdated,
    title: _i18n.i18n.translate('xpack.enterpriseSearch.content.index.syncJobs.events.lastUpdated', {
      defaultMessage: 'Last updated'
    })
  }, {
    date: completed,
    title: _i18n.i18n.translate('xpack.enterpriseSearch.content.index.syncJobs.events.completed', {
      defaultMessage: 'Completed'
    })
  }, {
    date: cancelationRequestedAt,
    title: _i18n.i18n.translate('xpack.enterpriseSearch.content.index.syncJobs.events.cancelationRequested', {
      defaultMessage: 'Cancelation requested'
    })
  }, {
    date: canceledAt,
    title: _i18n.i18n.translate('xpack.enterpriseSearch.content.index.syncJobs.events.canceled', {
      defaultMessage: 'Canceled'
    })
  }].filter(({
    date
  }) => !!date).sort(({
    date
  }, {
    date: dateB
  }) => (0, _moment.default)(date).isAfter((0, _moment.default)(dateB)) ? 1 : -1);
  const columns = [{
    field: 'title',
    name: _i18n.i18n.translate('xpack.enterpriseSearch.content.index.syncJobs.events.state', {
      defaultMessage: 'State'
    }),
    width: '50%'
  }, {
    field: 'date',
    name: _i18n.i18n.translate('xpack.enterpriseSearch.content.index.syncJobs.events.time', {
      defaultMessage: 'Time'
    }),
    render: date => /*#__PURE__*/_react.default.createElement(_formatted_date_time.FormattedDateTime, {
      date: new Date(date)
    }),
    width: '50%'
  }];
  return /*#__PURE__*/_react.default.createElement(_flyout_panel.FlyoutPanel, {
    title: _i18n.i18n.translate('xpack.enterpriseSearch.content.index.syncJobs.events.title', {
      defaultMessage: 'Events'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    columns: columns,
    items: events
  }));
};
exports.SyncJobEventsPanel = SyncJobEventsPanel;