"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchIndexRouter = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _kea = require("kea");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _routes = require("../../routes");
var _index_name_logic = require("./index_name_logic");
var _index_view_logic = require("./index_view_logic");
var _search_index = require("./search_index");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SearchIndexRouter = () => {
  const indexName = decodeURIComponent((0, _reactRouterDom.useParams)().indexName);
  const {
    setIndexName
  } = (0, _kea.useActions)(_index_name_logic.IndexNameLogic);
  const {
    stopFetchIndexPoll
  } = (0, _kea.useActions)(_index_view_logic.IndexViewLogic);
  (0, _react.useEffect)(() => {
    const unmountName = _index_name_logic.IndexNameLogic.mount();
    const unmountView = _index_view_logic.IndexViewLogic.mount();
    return () => {
      stopFetchIndexPoll();
      unmountName();
      unmountView();
    };
  }, []);
  (0, _react.useEffect)(() => {
    setIndexName(indexName);
  }, [indexName]);
  return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Switch, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _routes.SEARCH_INDEX_PATH,
    exact: true
  }, /*#__PURE__*/_react.default.createElement(_search_index.SearchIndex, null)), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _routes.SEARCH_INDEX_TAB_DETAIL_PATH
  }, /*#__PURE__*/_react.default.createElement(_search_index.SearchIndex, null)), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _routes.SEARCH_INDEX_TAB_PATH
  }, /*#__PURE__*/_react.default.createElement(_search_index.SearchIndex, null)), /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
    from: _routes.OLD_SEARCH_INDEX_CRAWLER_DOMAIN_DETAIL_PATH,
    to: `${_routes.SEARCH_INDEX_PATH}/domain_management/:domainId}`
  }));
};
exports.SearchIndexRouter = SearchIndexRouter;