"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ManageCustomPipelineActions = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _uiTheme = require("@kbn/ui-theme");
var _pipelines_logic = require("../pipelines_logic");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const revertContextMenuItemCSS = (0, _react2.css)`
  color: ${_uiTheme.euiThemeVars.euiColorDanger};
`;
const ManageCustomPipelineActions = () => {
  const [isMenuOpen, setIsMenuOpen] = (0, _react.useState)(false);
  const {
    openDeleteModal
  } = (0, _kea.useActions)(_pipelines_logic.PipelinesLogic);
  const onButtonClick = () => setIsMenuOpen(!isMenuOpen);
  const onRevertClick = () => {
    openDeleteModal();
    setIsMenuOpen(false);
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      size: "s",
      iconType: "arrowDown",
      iconSide: "right",
      onClick: onButtonClick
    }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.ingestionPipeline.manageButton', {
      defaultMessage: 'Manage'
    })),
    isOpen: isMenuOpen,
    closePopover: () => setIsMenuOpen(false),
    panelPaddingSize: "none",
    anchorPosition: "downRight"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    size: "s",
    items: [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      onClick: onRevertClick,
      icon: "trash",
      css: revertContextMenuItemCSS
    }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.ingestionPipeline.revertPipelineAction', {
      defaultMessage: 'Revert to default configuration'
    }))]
  }));
};
exports.ManageCustomPipelineActions = ManageCustomPipelineActions;