"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IngestPipelineFlyout = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _doc_links = require("../../../../../shared/doc_links");
var _curl_request = require("../../components/curl_request/curl_request");
var _pipeline_settings_form = require("../pipeline_settings_form");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const IngestPipelineFlyout = ({
  closeFlyout,
  displayOnly,
  extractionDisabled,
  indexName,
  ingestionMethod,
  isLoading,
  pipeline,
  savePipeline,
  setPipeline
}) => {
  const {
    name
  } = pipeline;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: closeFlyout,
    maxWidth: '40rem'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.enterpriseSearch.content.index.pipelines.ingestFlyout.modalHeaderTitle', {
    defaultMessage: 'Pipeline settings'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement("strong", null, name))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, extractionDisabled ? /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.enterpriseSearch.content.index.pipelines.settings.extractBinaryDisabledWarningTitle', {
      defaultMessage: 'Content extraction cannot be configured'
    }),
    color: "warning",
    iconType: "warning"
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.content.index.pipelines.settings.extractBinaryDisabledWarningContent', {
    defaultMessage: 'Because local content extraction is enabled for this connector, pipeline content extraction settings cannot be used.'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: `${_doc_links.docLinks.connectorsContentExtraction}#connectors-content-extraction-local`,
    target: "_blank"
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.index.pipelines.ingestFlyout.modalIngestLinkLocalExtractionLabel', {
    defaultMessage: 'Learn more about local content extraction.'
  }))) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, displayOnly ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.content.index.pipelines.ingestFlyout.modalBodyAPIText",
    defaultMessage: "{apiIndex} Changes made to the settings below are for reference only. These settings will not be persisted to your index or pipeline.",
    values: {
      apiIndex: /*#__PURE__*/_react.default.createElement("strong", null, _i18n.i18n.translate('xpack.enterpriseSearch.content.index.pipelines.ingestFlyout.apiIndex', {
        defaultMessage: 'This is an API-based index.'
      }))
    }
  })), /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.content.index.pipelines.ingestFlyout.modalBodyAPITextCont', {
    defaultMessage: "In order to use this pipeline on your API-based indices you'll need to explicitly reference it in your API requests."
  }))) : _i18n.i18n.translate('xpack.enterpriseSearch.content.index.pipelines.ingestFlyout.modalBodyConnectorText', {
    defaultMessage: 'This pipeline runs automatically on all Crawler and Connector indices created through Enterprise Search.'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: _doc_links.docLinks.ingestPipelines,
    external: true
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.index.pipelines.ingestFlyout.modalIngestLinkLabel', {
    defaultMessage: 'Learn more about Enterprise Search ingest pipelines'
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    "aria-labelledby": "ingestPipelineHeader"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "m",
    id: "ingestPipelineHeader"
  }, /*#__PURE__*/_react.default.createElement("strong", null, _i18n.i18n.translate('xpack.enterpriseSearch.content.index.pipelines.settings.formHeader', {
    defaultMessage: 'Optimize your content for search'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_pipeline_settings_form.PipelineSettingsForm, {
    extractionDisabled: extractionDisabled,
    ingestionMethod: ingestionMethod,
    pipeline: pipeline,
    setPipeline: setPipeline
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)), displayOnly && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "m",
    id: "ingestPipelineHeader",
    grow: false
  }, /*#__PURE__*/_react.default.createElement("strong", null, _i18n.i18n.translate('xpack.enterpriseSearch.content.index.pipelines.ingestFlyout.curlHeader', {
    defaultMessage: 'Sample cURL request to ingest a document'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_curl_request.CurlRequest, {
    document: {
      body: 'body',
      title: 'Title'
    },
    indexName: indexName,
    pipeline: pipeline
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, displayOnly ? /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    onClick: closeFlyout
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.index.pipelines.ingestFlyout.closeButtonLabel', {
    defaultMessage: 'Close'
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: closeFlyout
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.index.pipelines.ingestFlyout.cancelButtonLabel', {
    defaultMessage: 'Cancel'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    onClick: savePipeline,
    isLoading: isLoading
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.index.pipelines.ingestFlyout.saveButtonLabel', {
    defaultMessage: 'Save'
  }))))));
};
exports.IngestPipelineFlyout = IngestPipelineFlyout;