"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DefaultPipelineItem = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _indices = require("../../../../utils/indices");
var _curl_request = require("../../components/curl_request/curl_request");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DefaultPipelineItem = ({
  index,
  indexName,
  ingestionMethod,
  openPipelineSettings,
  pipelineName,
  pipelineState
}) => {
  /**
   * If we don't open the accordion on load, the curl code never shows the copy button
   * Because if the accordion is closed, the code block is not present in the DOM
   * And EuiCodeBlock doesn't show the copy button if it's virtualized (ie not present in DOM)
   * It doesn't re-evaluate whether it's present in DOM if the inner text doesn't change
   * Opening and closing makes sure it's present in DOM on initial load, so the copy button shows
   * We use setImmediate to then close it on the next javascript loop
   */
  const [accordionOpen, setAccordionOpen] = (0, _react.useState)(true);
  (0, _react.useEffect)(() => {
    setImmediate(() => setAccordionOpen(false));
  }, []);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h4", null, pipelineName))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-telemetry-id": `entSearchContent-${ingestionMethod}-pipelines-ingestPipelines-settings`,
    onClick: openPipelineSettings
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.ingestPipelinesCard.settings.label', {
    defaultMessage: 'Settings'
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd"
  }, (0, _indices.isApiIndex)(index) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    "data-telemetry-id": `entSearchContent-${ingestionMethod}-pipelines-ingestPipelines-viewCurlRequest`,
    buttonContent: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.ingestPipelinesCard.accordion.label', {
      defaultMessage: 'Ingest a document using cURL'
    }),
    id: "ingestPipelinesCurlAccordion",
    forceState: accordionOpen ? 'open' : 'closed',
    onClick: () => setAccordionOpen(!accordionOpen)
  }, /*#__PURE__*/_react.default.createElement(_curl_request.CurlRequest, {
    document: {
      body: 'body',
      title: 'Title'
    },
    indexName: indexName,
    pipeline: {
      ...pipelineState,
      name: pipelineName
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "hollow",
    iconType: "lock"
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.ingestPipelinesCard.managedBadge.label', {
    defaultMessage: 'Managed'
  })))))));
};
exports.DefaultPipelineItem = DefaultPipelineItem;