"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectorSyncRulesForm = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _unsaved_changes_prompt = require("../../../../../shared/unsaved_changes_prompt");
var _connector_filtering_logic = require("./connector_filtering_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConnectorSyncRulesForm = ({
  children
}) => {
  const {
    saveDraftFilteringRules,
    setIsEditing
  } = (0, _kea.useActions)(_connector_filtering_logic.ConnectorFilteringLogic);
  const {
    hasJsonValidationError,
    isEditing,
    isLoading
  } = (0, _kea.useValues)(_connector_filtering_logic.ConnectorFilteringLogic);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_unsaved_changes_prompt.UnsavedChangesPrompt, {
    hasUnsavedChanges: isEditing,
    messageText: _i18n.i18n.translate('xpack.enterpriseSearch.index.connector.syncRules.unsavedChanges', {
      defaultMessage: 'Your changes have not been saved. Are you sure you want to leave?'
    })
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, null, children)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, isEditing && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-telemetry-id": "entSearchContent-connector-syncRules-editRules-cancelEditing",
    onClick: () => {
      setIsEditing(!isEditing);
    }
  }, _i18n.i18n.translate('xpack.enterpriseSearch.index.connector.syncRules.cancelEditingFilteringDraft', {
    defaultMessage: 'Cancel'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-telemetry-id": "entSearchContent-connector-syncRules-editRules-saveAndValidate",
    disabled: hasJsonValidationError,
    isLoading: isLoading,
    onClick: saveDraftFilteringRules
  }, _i18n.i18n.translate('xpack.enterpriseSearch.index.connector.syncRules.validateDraftTitle', {
    defaultMessage: 'Save and validate draft'
  }))))));
};
exports.ConnectorSyncRulesForm = ConnectorSyncRulesForm;