"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NativeConnectorConfigurationConfig = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _connectors = require("../../../../../../../common/types/connectors");
var _doc_links = require("../../../../../shared/doc_links");
var _connector_configuration_config = require("../connector_configuration_config");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NativeConnectorConfigurationConfig = ({
  nativeConnector,
  status
}) => {
  return /*#__PURE__*/_react.default.createElement(_connector_configuration_config.ConnectorConfigurationConfig, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.configurationConnector.nativeConnector.config.encryptionWarningMessage', {
    defaultMessage: 'Encryption for data source credentials is unavailable in this version. Your data source credentials will be stored, unencrypted, in Elasticsearch.'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: _doc_links.docLinks.elasticsearchSecureCluster,
    target: "_blank"
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.configurationConnector.nativeConnector.config.securityDocumentationLinkLabel', {
    defaultMessage: 'Learn more about Elasticsearch security'
  }))), nativeConnector.externalAuthDocsUrl && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: nativeConnector.externalAuthDocsUrl,
    target: "_blank"
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.configurationConnector.nativeConnector.config.sourceSecurityDocumentationLinkLabel', {
    defaultMessage: '{name} authentication',
    values: {
      name: nativeConnector.name
    }
  })))), status === _connectors.ConnectorStatus.CONNECTED && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    iconType: "check",
    color: "success",
    title: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.configurationConnector.nativeConnector.connectorConnected', {
      defaultMessage: 'Your connector {name} has connected to Enterprise Search successfully.',
      values: {
        name: nativeConnector.name
      }
    })
  })));
};
exports.NativeConnectorConfigurationConfig = NativeConnectorConfigurationConfig;