"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NativeConnectorConfiguration = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _beta_connector_callout = require("../../../../../shared/beta/beta_connector_callout");
var _doc_links = require("../../../../../shared/doc_links");
var _connector_icons = require("../../../../../shared/icons/connector_icons");
var _has_configured_configuration = require("../../../../utils/has_configured_configuration");
var _indices = require("../../../../utils/indices");
var _index_view_logic = require("../../index_view_logic");
var _connector_name_and_description = require("../connector_name_and_description/connector_name_and_description");
var _constants = require("../constants");
var _convert_connector = require("./convert_connector");
var _native_connector_advanced_configuration = require("./native_connector_advanced_configuration");
var _native_connector_configuration_config = require("./native_connector_configuration_config");
var _research_configuration = require("./research_configuration");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NativeConnectorConfiguration = () => {
  var _index$connector$serv, _nativeConnector$name;
  const {
    index
  } = (0, _kea.useValues)(_index_view_logic.IndexViewLogic);
  if (!(0, _indices.isConnectorIndex)(index)) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
  }
  const nativeConnector = _constants.NATIVE_CONNECTORS.find(connector => connector.serviceType === index.connector.service_type) || {
    docsUrl: '',
    externalAuthDocsUrl: '',
    externalDocsUrl: '',
    icon: _connector_icons.CONNECTOR_ICONS.custom,
    iconPath: 'custom.svg',
    isBeta: true,
    isNative: true,
    keywords: [],
    name: index.connector.name,
    serviceType: (_index$connector$serv = index.connector.service_type) !== null && _index$connector$serv !== void 0 ? _index$connector$serv : ''
  };
  const hasDescription = !!index.connector.description;
  const hasConfigured = (0, _has_configured_configuration.hasConfiguredConfiguration)(index.connector.configuration);
  const hasConfiguredAdvanced = index.connector.last_synced || index.connector.scheduling.full.enabled || index.connector.scheduling.incremental.enabled;
  const hasResearched = hasDescription || hasConfigured || hasConfiguredAdvanced;
  const icon = nativeConnector.icon;

  // TODO service_type === "" is considered unknown/custom connector multipleplaces replace all of them with a better solution
  const isBeta = !index.connector.service_type || Boolean(_constants.BETA_CONNECTORS.find(({
    serviceType
  }) => serviceType === index.connector.service_type));
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 2
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    direction: "row",
    alignItems: "center"
  }, icon && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    size: "xl",
    type: icon
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h3", null, (_nativeConnector$name = nativeConnector === null || nativeConnector === void 0 ? void 0 : nativeConnector.name) !== null && _nativeConnector$name !== void 0 ? _nativeConnector$name : index.connector.name)))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSteps, {
    steps: [{
      children: /*#__PURE__*/_react.default.createElement(_research_configuration.ResearchConfiguration, {
        nativeConnector: nativeConnector
      }),
      status: hasResearched ? 'complete' : 'incomplete',
      title: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.configurationConnector.nativeConnector.steps.researchConfigurationTitle', {
        defaultMessage: 'Research configuration requirements'
      }),
      titleSize: 'xs'
    }, {
      children: /*#__PURE__*/_react.default.createElement(_connector_name_and_description.ConnectorNameAndDescription, null),
      status: hasDescription ? 'complete' : 'incomplete',
      title: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.configurationConnector.nativeConnector.steps.nameAndDescriptionTitle', {
        defaultMessage: 'Name and description'
      }),
      titleSize: 'xs'
    }, {
      children: /*#__PURE__*/_react.default.createElement(_native_connector_configuration_config.NativeConnectorConfigurationConfig, {
        nativeConnector: nativeConnector,
        status: index.connector.status
      }),
      status: hasConfigured ? 'complete' : 'incomplete',
      title: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.configurationConnector.nativeConnector.steps.configurationTitle', {
        defaultMessage: 'Configuration'
      }),
      titleSize: 'xs'
    }, {
      children: /*#__PURE__*/_react.default.createElement(_native_connector_advanced_configuration.NativeConnectorAdvancedConfiguration, null),
      status: hasConfiguredAdvanced ? 'complete' : 'incomplete',
      title: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.configurationConnector.nativeConnector.steps.advancedConfigurationTitle', {
        defaultMessage: 'Advanced configuration'
      }),
      titleSize: 'xs'
    }]
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    hasShadow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    alignItems: "center",
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "clock"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs"
  }, /*#__PURE__*/_react.default.createElement("h4", null, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.configurationConnector.nativeConnector.schedulingReminder.title', {
    defaultMessage: 'Configurable sync schedule'
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.configurationConnector.nativeConnector.schedulingReminder.description', {
    defaultMessage: 'Remember to set a sync schedule in the Scheduling tab to continually refresh your searchable data.'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    hasShadow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    alignItems: "center",
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "globe"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs"
  }, /*#__PURE__*/_react.default.createElement("h4", null, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.configurationConnector.nativeConnector.securityReminder.title', {
    defaultMessage: 'Document level security'
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.configurationConnector.nativeConnector.securityReminder.description', {
    defaultMessage: 'Restrict and personalize the read access users have to the index documents at query time.'
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: _doc_links.docLinks.documentLevelSecurity,
    target: "_blank"
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.configurationConnector.nativeConnector.securityReminder.securityLinkLabel', {
    defaultMessage: 'Document level security'
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    hasShadow: false
  }, /*#__PURE__*/_react.default.createElement(_convert_connector.ConvertConnector, null))), isBeta ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    hasShadow: false
  }, /*#__PURE__*/_react.default.createElement(_beta_connector_callout.BetaConnectorCallout, null))) : null))));
};
exports.NativeConnectorConfiguration = NativeConnectorConfiguration;