"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectorSchedulingLogic = void 0;
var _kea = require("kea");
var _connectors = require("../../../../../../common/types/connectors");
var _update_connector_scheduling_api_logic = require("../../../api/connector/update_connector_scheduling_api_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConnectorSchedulingLogic = (0, _kea.kea)({
  actions: {
    clearHasChanges: type => ({
      type
    }),
    setHasChanges: type => ({
      type
    }),
    updateScheduling: (type, payload) => ({
      payload,
      type
    })
  },
  connect: {
    actions: [_update_connector_scheduling_api_logic.UpdateConnectorSchedulingApiLogic, ['apiSuccess', 'makeRequest']]
  },
  listeners: ({
    actions,
    values
  }) => ({
    apiSuccess: () => {
      if (values.makeRequestType) {
        actions.clearHasChanges(values.makeRequestType);
      }
    },
    updateScheduling: ({
      payload
    }) => {
      actions.makeRequest(payload);
    }
  }),
  reducers: {
    hasAccessSyncChanges: [false, {
      clearHasChanges: (current, {
        type
      }) => type === _connectors.SyncJobType.ACCESS_CONTROL ? false : current,
      setHasChanges: (current, {
        type
      }) => type === _connectors.SyncJobType.ACCESS_CONTROL ? true : current
    }],
    hasFullSyncChanges: [false, {
      clearHasChanges: (current, {
        type
      }) => type === _connectors.SyncJobType.FULL ? false : current,
      setHasChanges: (current, {
        type
      }) => type === _connectors.SyncJobType.FULL ? true : current
    }],
    hasIncrementalSyncChanges: [false, {
      clearHasChanges: (current, {
        type
      }) => type === _connectors.SyncJobType.INCREMENTAL ? false : current,
      setHasChanges: (current, {
        type
      }) => type === _connectors.SyncJobType.INCREMENTAL ? true : current
    }],
    makeRequestType: [null, {
      updateScheduling: (_, {
        type
      }) => type
    }]
  },
  selectors: ({
    selectors
  }) => ({
    hasChanges: [() => [selectors.hasFullSyncChanges, selectors.hasAccessSyncChanges, selectors.hasIncrementalSyncChanges], (hasFullSyncChanges, hasAccessSyncChanges, hasIncrementalSyncChanges) => {
      return hasFullSyncChanges || hasAccessSyncChanges || hasIncrementalSyncChanges;
    }]
  })
});
exports.ConnectorSchedulingLogic = ConnectorSchedulingLogic;