"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createMlInferencePipeline = exports.CreateMlInferencePipelineApiLogic = void 0;
var _create_api_logic = require("../../../shared/api_logic/create_api_logic");
var _http = require("../../../shared/http");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isArgsWithPipelineParameters = args => {
  return typeof args.modelId === 'string';
};
const isArgsWithPipelineDefinition = args => {
  return typeof args.pipelineDefinition === 'object';
};
const createMlInferencePipeline = async args => {
  const route = `/internal/enterprise_search/indices/${args.indexName}/ml_inference/pipeline_processors`;
  let params;
  if (isArgsWithPipelineParameters(args)) {
    params = {
      destination_field: args.destinationField,
      inference_config: args.inferenceConfig,
      model_id: args.modelId,
      pipeline_definition: undefined,
      pipeline_name: args.pipelineName,
      source_field: args.sourceField
    };
  } else if (isArgsWithPipelineDefinition(args)) {
    params = {
      field_mappings: args.fieldMappings,
      pipeline_definition: args.pipelineDefinition,
      pipeline_name: args.pipelineName
    };
  }
  return await _http.HttpLogic.values.http.post(route, {
    body: JSON.stringify(params)
  });
};
exports.createMlInferencePipeline = createMlInferencePipeline;
const CreateMlInferencePipelineApiLogic = (0, _create_api_logic.createApiLogic)(['create_ml_inference_pipeline_api_logic'], createMlInferencePipeline);
exports.CreateMlInferencePipelineApiLogic = CreateMlInferencePipelineApiLogic;