"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.addExtractionRule = exports.AddExtractionRuleApiLogic = void 0;
var _create_api_logic = require("../../../../shared/api_logic/create_api_logic");
var _http = require("../../../../shared/http");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const addExtractionRule = async ({
  domainId,
  indexName,
  rule: {
    description,
    rules,
    url_filters: urlFilters
  }
}) => {
  const route = `/internal/enterprise_search/indices/${indexName}/crawler/domains/${domainId}/extraction_rules`;
  const params = {
    extraction_rule: {
      description,
      rules,
      url_filters: urlFilters
    }
  };
  return await _http.HttpLogic.values.http.post(route, {
    body: JSON.stringify(params)
  });
};
exports.addExtractionRule = addExtractionRule;
const AddExtractionRuleApiLogic = (0, _create_api_logic.createApiLogic)(['add_extraction_rule_api_logic'], addExtractionRule);
exports.AddExtractionRuleApiLogic = AddExtractionRuleApiLogic;