"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Elasticsearch = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _is_version_mismatch = require("../../../common/is_version_mismatch");
var _version_mismatch = require("../shared/version_mismatch");
var _elasticsearch_guide = require("./components/elasticsearch_guide");
var _routes = require("./routes");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Elasticsearch = props => {
  const {
    enterpriseSearchVersion,
    kibanaVersion
  } = props;
  const incompatibleVersions = (0, _is_version_mismatch.isVersionMismatch)(enterpriseSearchVersion, kibanaVersion);
  const showView = () => {
    if (incompatibleVersions) {
      return /*#__PURE__*/_react.default.createElement(_version_mismatch.VersionMismatchPage, {
        enterpriseSearchVersion: enterpriseSearchVersion,
        kibanaVersion: kibanaVersion
      });
    }
    return /*#__PURE__*/_react.default.createElement(_elasticsearch_guide.ElasticsearchGuide, null);
  };
  return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Switch, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: _routes.ROOT_PATH
  }, showView()));
};
exports.Elasticsearch = Elasticsearch;