"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ElasticsearchRust = void 0;
var _react = _interopRequireDefault(require("react"));
var _dedent = _interopRequireDefault(require("dedent"));
var _eui = require("@elastic/eui");
var _doc_links = require("../../../../shared/doc_links");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ElasticsearchRust = () => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, "The official Rust client for Elasticsearch includes all the features you need to add search to a Rust application:"), /*#__PURE__*/_react.default.createElement("ul", null, /*#__PURE__*/_react.default.createElement("li", null, "Fluent builders for all Elasticsearch REST API endpoints"), /*#__PURE__*/_react.default.createElement("li", null, "Persistent keep-alive connections"), /*#__PURE__*/_react.default.createElement("li", null, "TLS support with system or custom certificates"), /*#__PURE__*/_react.default.createElement("li", null, "Proxy support with authentication"), /*#__PURE__*/_react.default.createElement("li", null, "Async support with Tokio")), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    target: "_blank",
    href: _doc_links.docLinks.clientsRustOverview
  }, "Learn more about the Rust client for Elasticsearch"), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    target: "_blank",
    href: "https://github.com/elastic/elasticsearch-rs"
  }, "The official Rust client for Elasticsearch on Github"), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    target: "_blank",
    href: "https://docs.rs/elasticsearch"
  }, "View the documentation on docs.rs")), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("h4", null, "Installation"), /*#__PURE__*/_react.default.createElement("p", null, "Add ", /*#__PURE__*/_react.default.createElement("code", null, "elasticsearch"), " crate and version to Cargo.toml.")), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    fontSize: "m",
    isCopyable: true
  }, (0, _dedent.default)`
          [dependencies]
          elasticsearch = "<ELASTICSEARCH_VERSION>"
        `), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, "The following optional dependencies may also be useful to create requests and read responses")), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    fontSize: "m",
    isCopyable: true
  }, (0, _dedent.default)`
          serde = "~1"
          serde_json = "~1"
        `), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, "The client also includes", ' ', /*#__PURE__*/_react.default.createElement("a", {
    target: "_blank",
    rel: "noopener",
    href: "https://github.com/elastic/elasticsearch-rs#async-support-with-tokio"
  }, "async support with tokio"), ".")));
};
exports.ElasticsearchRust = ElasticsearchRust;