"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ElasticsearchPhp = void 0;
var _react = _interopRequireDefault(require("react"));
var _dedent = _interopRequireDefault(require("dedent"));
var _eui = require("@elastic/eui");
var _doc_links = require("../../../../shared/doc_links");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ElasticsearchPhp = ({
  cloudId
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, "This official PHP client for Elasticsearch is designed to be a low-level client that does not stray from the Elasticsearch REST API."), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    target: "_blank",
    href: _doc_links.docLinks.clientsPhpOverview
  }, "Learn more about the official PHP client for Elasticsearch"), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    target: "_blank",
    href: "https://github.com/elastic/elasticsearch-php"
  }, "The official PHP client for Elasticsearch on Github")), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("h4", null, "Installation"), /*#__PURE__*/_react.default.createElement("p", null, "To install the latest version of the client, run the following command:"), /*#__PURE__*/_react.default.createElement("p", null, "Elasticsearch-php only has four requirements that you need to pay attention:"), /*#__PURE__*/_react.default.createElement("ul", null, /*#__PURE__*/_react.default.createElement("li", null, "PHP 7.1.0 or higher"), /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement("a", {
    target: "_blank",
    rel: "noopener",
    href: "http://getcomposer.org/"
  }, "Composer")), /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement("a", {
    target: "_blank",
    rel: "noopener",
    href: "http://php.net/manual/en/book.curl.php"
  }, "ext-curl"), ": the Libcurl extension for PHP"), /*#__PURE__*/_react.default.createElement("li", null, "Native JSON Extensions (ext-json) 1.3.7 or higher")), /*#__PURE__*/_react.default.createElement("p", null, "The rest of the dependencies are automatically downloaded and installed by Composer. Composer is a package and dependency manager for PHP and makes it easy to install Elasticsearch-php."), /*#__PURE__*/_react.default.createElement("a", {
    target: "_blank",
    rel: "noopener",
    href: _doc_links.docLinks.clientsPhpInstallation
  }, "Visit the documentation for more information.")), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), cloudId ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("h4", null, "Connecting to Elastic Cloud"), /*#__PURE__*/_react.default.createElement("p", null, "You can connect to Elastic Cloud using ", /*#__PURE__*/_react.default.createElement("strong", null, "Basic authentication"), " or an", ' ', /*#__PURE__*/_react.default.createElement("strong", null, "API key"), ". Where ", '<cloud-id>', " is reported in the Deployment UI. For basic authentication, ", '<username>', " and ", '<password>', " are generated when you deploy a new cloud instance. You\u2019ll need to store the ", '<username>', " and ", '<password>', " since they will not be available via UI.")), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    fontSize: "m",
    isCopyable: true,
    language: "php"
  }, (0, _dedent.default)`
              // Connect via basic authentication
              $client = ClientBuilder::create()
                 ->setElasticCloudId('${cloudId}')
                 ->setBasicAuthentication('<username>', '<password>')
                 ->build();
              
              // Connect with an API key
              $client = ClientBuilder::create()
                 ->setElasticCloudId('${cloudId}')
                 ->setApiKey('<id>', '<key>')
                 ->build();
            `)) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("h4", null, "Connecting to Elasticsearch"), /*#__PURE__*/_react.default.createElement("p", null, "There are several ways to connect and authenticate to Elasticsearch running outside of Cloud, including API keys, bearer tokens, and basic authentication.", ' ', /*#__PURE__*/_react.default.createElement("a", {
    target: "_blank",
    rel: "noopener",
    href: _doc_links.docLinks.clientsPhpConnecting
  }, "Visit the client\u2019s documentation to learn more"), "."))));
};
exports.ElasticsearchPhp = ElasticsearchPhp;