"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ElasticsearchJava = void 0;
var _react = _interopRequireDefault(require("react"));
var _dedent = _interopRequireDefault(require("dedent"));
var _eui = require("@elastic/eui");
var _doc_links = require("../../../../shared/doc_links");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ElasticsearchJava = () => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, "The Elasticsearch Java API Client includes all the features you need to add search to a Java application:"), /*#__PURE__*/_react.default.createElement("ul", null, /*#__PURE__*/_react.default.createElement("li", null, "Strongly typed requests and responses for all Elasticsearch APIs."), /*#__PURE__*/_react.default.createElement("li", null, "Blocking and asynchronous versions of all APIs."), /*#__PURE__*/_react.default.createElement("li", null, "Use of fluent builders and functional patterns to allow writing concise yet readable code when creating complex nested structures."), /*#__PURE__*/_react.default.createElement("li", null, "Seamless integration of application classes by using an object mapper such as Jackson or any JSON-B implementation.")), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    target: "_blank",
    href: _doc_links.docLinks.clientsJavaIntroduction
  }, "Learn more about the Elasticsearch JAVA API client"), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    target: "_blank",
    href: "https://github.com/elastic/elasticsearch-java"
  }, "The Elasticsearch JAVA API client on Github")), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("h4", null, "Installation"), /*#__PURE__*/_react.default.createElement("p", null, "There are several ways to install the Java API client.", ' ', /*#__PURE__*/_react.default.createElement("a", {
    target: "_blank",
    rel: "noopener",
    href: _doc_links.docLinks.clientsJavaInstallation
  }, "Visit the client documentation to learn more"), "."), /*#__PURE__*/_react.default.createElement("h4", null, "Connecting to Elasticsearch"), /*#__PURE__*/_react.default.createElement("p", null, "The client is structured around three main components:"), /*#__PURE__*/_react.default.createElement("ul", null, /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement("strong", null, "API client classes."), " These provide strongly typed data structures and methods for Elasticsearch APIs. Since the Elasticsearch API is large, it is structured in feature groups (also called \u201Cnamespaces\u201D), each having its own client class. Elasticsearch core features are implemented in the ElasticsearchClient class."), /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement("strong", null, "A JSON object mapper."), " This maps your application classes to JSON and seamlessly integrates them with the API client."), /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement("strong", null, "A transport layer implementation."), " This is where all HTTP request handling takes place.")), /*#__PURE__*/_react.default.createElement("p", null, "The code snippet below creates and wires these three components together:")), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    fontSize: "m",
    isCopyable: true,
    language: "java"
  }, (0, _dedent.default)`
          // Create the low-level client
          RestClient restClient = RestClient.builder(
              new HttpHost("localhost", 9200)).build();
          
          // Create the transport with a Jackson mapper
          ElasticsearchTransport transport = new RestClientTransport(
              restClient, new JacksonJsonpMapper());
          
          // And create the API client
          ElasticsearchClient client = new ElasticsearchClient(transport);
        `), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, "Authentication is managed by the", ' ', /*#__PURE__*/_react.default.createElement("a", {
    target: "_blank",
    rel: "noopener",
    href: _doc_links.docLinks.clientsJavaRestLow
  }, "Java Low Level REST Client"), ". For further details on configuring authentication, refer to", ' ', /*#__PURE__*/_react.default.createElement("a", {
    target: "_blank",
    rel: "noopener",
    href: _doc_links.docLinks.clientsJavaBasicAuthentication
  }, "its documentation"), ".")));
};
exports.ElasticsearchJava = ElasticsearchJava;