"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Sorting = exports.SearchBar = exports.ResultsView = exports.ResultsPerPageView = exports.ResultView = exports.RESULTS_PER_PAGE_OPTIONS = exports.PagingInfoView = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _reactSearchUi = require("@elastic/react-search-ui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _health_colors = require("../../../../shared/constants/health_colors");
var _search_application_view_logic = require("../search_application_view_logic");
var _convert_results = require("./convert_results");
var _document_context = require("./document_context");
var _field_value_cell = require("./field_value_cell");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ResultsView = ({
  children
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, children);
};
exports.ResultsView = ResultsView;
const RESULT_FIELDS_TRUNCATE_AT = 4;
const ResultView = ({
  result
}) => {
  var _searchApplicationDat;
  const {
    searchApplicationData
  } = (0, _kea.useValues)(_search_application_view_logic.SearchApplicationViewLogic);
  const {
    setSelectedDocument
  } = (0, _document_context.useSelectedDocument)();
  const {
    fields,
    index
  } = (0, _convert_results.convertResultToFieldsAndIndex)(result);
  const id = result._meta.rawHit.__id;
  const truncatedFields = fields.slice(0, RESULT_FIELDS_TRUNCATE_AT);
  const hiddenFields = fields.length - truncatedFields.length;
  const indexHealth = searchApplicationData === null || searchApplicationData === void 0 ? void 0 : (_searchApplicationDat = searchApplicationData.indices.find(i => i.name === index)) === null || _searchApplicationDat === void 0 ? void 0 : _searchApplicationDat.health;
  const badgeColor = !indexHealth || indexHealth === 'unknown' ? 'hollow' : (0, _health_colors.indexHealthToHealthColor)(indexHealth);
  const columns = [{
    field: 'field',
    name: _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.searchApplication.searchPreview.result.nameColumn', {
      defaultMessage: 'Field'
    }),
    render: field => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
        color: "subdued"
      }, /*#__PURE__*/_react.default.createElement("code", null, "\"", field, "\"")));
    },
    truncateText: true,
    width: '20%'
  }, {
    field: 'value',
    name: _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.searchApplication.searchPreview.result.valueColumn', {
      defaultMessage: 'Value'
    }),
    render: value => /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("code", null, /*#__PURE__*/_react.default.createElement(_field_value_cell.FieldValueCell, {
      value: value
    })))
  }];
  return /*#__PURE__*/_react.default.createElement("button", {
    type: "button",
    onClick: () => setSelectedDocument(result)
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement("code", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.searchApplications.searchApplication.searchPreview.result.id",
    defaultMessage: "ID: {id}",
    values: {
      id
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement("code", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.searchApplications.searchApplication.searchPreview.result.fromIndex",
    defaultMessage: "from"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: badgeColor
  }, index)))), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    items: truncatedFields,
    columns: columns
  }), hiddenFields > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "arrowRight",
    color: "subdued"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement("code", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.searchApplications.searchApplication.searchPreview.result.moreFieldsButton",
    defaultMessage: "{count} {count, plural, one {More Field} other {More Fields}}",
    values: {
      count: hiddenFields
    }
  })))))));
};
exports.ResultView = ResultView;
const SearchBar = ({
  additionalInputProps
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  gutterSize: "s"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldSearch, (0, _extends2.default)({
  fullWidth: true
}, additionalInputProps)), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
  type: "submit",
  color: "primary",
  fill: true
}, _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.searchApplication.searchPreview.inputView.searchLabel', {
  defaultMessage: 'Search'
})));
exports.SearchBar = SearchBar;
const PagingInfoView = ({
  start,
  end,
  totalResults
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "s"
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedHTMLMessage, {
  tagName: "p",
  id: "xpack.enterpriseSearch.searchApplications.searchApplication.searchPreview.pagingInfo.text",
  defaultMessage: "Showing <strong>{start}-{end}</strong> of {totalResults}",
  values: {
    end,
    start,
    totalResults
  }
}));
exports.PagingInfoView = PagingInfoView;
const RESULTS_PER_PAGE_OPTIONS = [10, 20, 50];
exports.RESULTS_PER_PAGE_OPTIONS = RESULTS_PER_PAGE_OPTIONS;
const ResultsPerPageView = ({
  onChange,
  options,
  value
}) => {
  var _options$map;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxxs"
  }, /*#__PURE__*/_react.default.createElement("label", {
    htmlFor: "results-per-page"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.searchApplications.searchApplication.searchPreview.resultsPerPage.label",
    defaultMessage: "Show"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    id: "results-per-page",
    options: (_options$map = options === null || options === void 0 ? void 0 : options.map(option => ({
      text: _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.searchApplication.searchPreview.resultsPerPage.option.label', {
        defaultMessage: '{value} {value, plural, one {Result} other {Results}}',
        values: {
          value: option
        }
      }),
      value: option
    }))) !== null && _options$map !== void 0 ? _options$map : [],
    value: value,
    onChange: evt => onChange(parseInt(evt.target.value, 10))
  })));
};
exports.ResultsPerPageView = ResultsPerPageView;
const Sorting = (0, _reactSearchUi.withSearch)(({
  setSort,
  sortList
}) => ({
  setSort,
  sortList
}))(({
  sortableFields,
  sortList,
  setSort
}) => {
  const [{
    direction,
    field
  }] = !(sortList !== null && sortList !== void 0 && sortList.length) ? [{
    direction: '',
    field: ''
  }] : sortList;
  const relevance = _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.searchApplication.searchPreview.sortingView.relevanceLabel', {
    defaultMessage: 'Relevance'
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxxs"
  }, /*#__PURE__*/_react.default.createElement("label", {
    htmlFor: "sorting-field"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.searchApplications.searchApplication.searchPreview.sortingView.fieldLabel",
    defaultMessage: "Sort By"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    id: "sorting-field",
    isClearable: false,
    singleSelection: {
      asPlainText: true
    },
    options: [{
      label: relevance,
      value: ''
    }, ...sortableFields.map(f => ({
      label: f,
      value: f
    }))],
    selectedOptions: [{
      label: !!field ? field : relevance,
      value: field
    }],
    onChange: ([{
      value
    }]) => setSort(value === '' ? [] : [{
      direction: 'asc',
      field: value
    }], 'asc')
  })), field !== '' && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxxs"
  }, /*#__PURE__*/_react.default.createElement("label", {
    htmlFor: "sorting-direction"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.searchApplications.searchApplication.searchPreview.sortingView.directionLabel",
    defaultMessage: "Order By"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    id: "sorting-direction",
    onChange: evt => {
      switch (evt.target.value) {
        case 'asc':
          return setSort([{
            direction: 'asc',
            field
          }], 'asc');
        case 'desc':
          return setSort([{
            direction: 'desc',
            field
          }], 'desc');
      }
    },
    value: direction,
    options: [{
      text: _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.searchApplication.searchPreview.sortingView.ascLabel', {
        defaultMessage: 'Ascending'
      }),
      value: 'asc'
    }, {
      text: _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.searchApplication.searchPreview.sortingView.descLabel', {
        defaultMessage: 'Descending'
      }),
      value: 'desc'
    }]
  }))));
});
exports.Sorting = Sorting;