"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchIndices = exports.FetchIndicesForSearchApplicationsAPILogic = void 0;
var _create_api_logic = require("../../../shared/api_logic/create_api_logic");
var _timers = require("../../../shared/constants/timers");
var _http = require("../../../shared/http");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const INDEX_SEARCH_PAGE_SIZE = 40;
const fetchIndices = async ({
  searchQuery
}) => {
  const {
    http
  } = _http.HttpLogic.values;
  const route = '/internal/enterprise_search/indices';
  const query = {
    from: 0,
    return_hidden_indices: false,
    search_query: searchQuery || null,
    size: INDEX_SEARCH_PAGE_SIZE
  };
  const response = await http.get(route, {
    query
  });
  return {
    ...response,
    searchQuery
  };
};
exports.fetchIndices = fetchIndices;
const FetchIndicesForSearchApplicationsAPILogic = (0, _create_api_logic.createApiLogic)(['search_applications', 'fetch_indices_api_logic'], fetchIndices, {
  requestBreakpointMS: _timers.INPUT_THROTTLE_DELAY_MS
});
exports.FetchIndicesForSearchApplicationsAPILogic = FetchIndicesForSearchApplicationsAPILogic;