"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TextFieldsBody = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _result_settings_logic = require("../result_settings_logic");
var _field_number = require("./field_number");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TextFieldsBody = () => {
  const {
    isSnippetAllowed,
    textResultFields
  } = (0, _kea.useValues)(_result_settings_logic.ResultSettingsLogic);
  const {
    toggleRawForField,
    updateRawSizeForField,
    clearRawSizeForField,
    toggleSnippetForField,
    updateSnippetSizeForField,
    clearSnippetSizeForField,
    toggleSnippetFallbackForField
  } = (0, _kea.useActions)(_result_settings_logic.ResultSettingsLogic);
  const resultSettingsArray = (0, _react.useMemo)(() => {
    return Object.entries(textResultFields).sort(([aFieldName], [bFieldName]) => aFieldName > bFieldName ? 1 : -1);
  }, [textResultFields]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, resultSettingsArray.map(([fieldName, fieldSettings]) => /*#__PURE__*/_react.default.createElement(_eui.EuiTableRow, {
    key: fieldName
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, {
    "data-test-subj": "ResultSettingFieldName"
  }, /*#__PURE__*/_react.default.createElement("code", null, fieldName)), /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCellCheckbox, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    "aria-label": _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.resultSettings.table.rawAriaLabel', {
      defaultMessage: 'Toggle raw field'
    }),
    "data-test-subj": "ResultSettingRawCheckBox",
    id: `${fieldName}-raw}`,
    checked: !!fieldSettings.raw,
    onChange: () => {
      toggleRawForField(fieldName);
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, {
    align: "center",
    textOnly: false
  }, /*#__PURE__*/_react.default.createElement(_field_number.FieldNumber, {
    fieldName: fieldName,
    fieldEnabledProperty: "raw",
    fieldSizeProperty: "rawSize",
    fieldSettings: fieldSettings,
    updateAction: updateRawSizeForField,
    clearAction: clearRawSizeForField
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCellCheckbox, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    "aria-label": _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.resultSettings.table.snippetAriaLabel', {
      defaultMessage: 'Toggle text snippet'
    }),
    "data-test-subj": "ResultSettingSnippetTextBox",
    id: `${fieldName}-snippet}`,
    checked: !!fieldSettings.snippet,
    disabled: !isSnippetAllowed(fieldName),
    onChange: () => {
      toggleSnippetForField(fieldName);
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCellCheckbox, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    "aria-label": _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.resultSettings.table.snippetFallbackAriaLabel', {
      defaultMessage: 'Toggle snippet fallback'
    }),
    "data-test-subj": "ResultSettingFallbackTextBox",
    id: `${fieldName}-snippetFallback}`,
    checked: fieldSettings.snippetFallback,
    disabled: !fieldSettings.snippet,
    onChange: () => {
      toggleSnippetFallbackForField(fieldName);
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, {
    align: "center",
    textOnly: false
  }, /*#__PURE__*/_react.default.createElement(_field_number.FieldNumber, {
    fieldName: fieldName,
    fieldEnabledProperty: "snippet",
    fieldSizeProperty: "snippetSize",
    fieldSettings: fieldSettings,
    updateAction: updateSnippetSizeForField,
    clearAction: clearSnippetSizeForField
  })))));
};
exports.TextFieldsBody = TextFieldsBody;