"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EnginesOverview = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _react_router_helpers = require("../../../shared/react_router_helpers");
var _table_pagination = require("../../../shared/table_pagination");
var _app_logic = require("../../app_logic");
var _icons = require("../../icons");
var _routes = require("../../routes");
var _data_panel = require("../data_panel");
var _layout = require("../layout");
var _components = require("./components");
var _audit_logs_modal = require("./components/audit_logs_modal/audit_logs_modal");
var _engines_table = require("./components/tables/engines_table");
var _meta_engines_table = require("./components/tables/meta_engines_table");
var _constants = require("./constants");
var _engines_logic = require("./engines_logic");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EnginesOverview = () => {
  const {
    myRole: {
      canManageEngines,
      canManageMetaEngines
    }
  } = (0, _kea.useValues)(_app_logic.AppLogic);
  const {
    dataLoading,
    engines,
    enginesMeta,
    enginesLoading,
    metaEngines,
    metaEnginesMeta,
    metaEnginesLoading
  } = (0, _kea.useValues)(_engines_logic.EnginesLogic);
  const {
    loadEngines,
    loadMetaEngines,
    onEnginesPagination,
    onMetaEnginesPagination
  } = (0, _kea.useActions)(_engines_logic.EnginesLogic);
  (0, _react.useEffect)(() => {
    loadEngines();
  }, [enginesMeta.page.current]);
  (0, _react.useEffect)(() => {
    loadMetaEngines();
  }, [metaEnginesMeta.page.current]);
  return /*#__PURE__*/_react.default.createElement(_layout.AppSearchPageTemplate, {
    pageViewTelemetry: "engines_overview",
    pageChrome: [_constants.ENGINES_TITLE],
    pageHeader: {
      pageTitle: _constants.ENGINES_OVERVIEW_TITLE
    },
    isLoading: dataLoading,
    isEmptyState: !engines.length && !metaEngines.length,
    emptyState: /*#__PURE__*/_react.default.createElement(_components.EmptyState, null)
  }, /*#__PURE__*/_react.default.createElement(_data_panel.DataPanel, {
    hasBorder: true,
    iconType: _icons.EngineIcon,
    title: /*#__PURE__*/_react.default.createElement("h2", null, _constants.ENGINES_TITLE),
    titleSize: "s",
    action: canManageEngines && /*#__PURE__*/_react.default.createElement(_react_router_helpers.EuiButtonTo, {
      color: "success",
      size: "s",
      iconType: "plusInCircle",
      "data-test-subj": "appSearchEnginesEngineCreationButton",
      to: _routes.ENGINE_CREATION_PATH
    }, _constants.CREATE_AN_ENGINE_BUTTON_LABEL),
    "data-test-subj": "appSearchEngines"
  }, /*#__PURE__*/_react.default.createElement(_engines_table.EnginesTable, {
    items: engines,
    loading: enginesLoading,
    pagination: {
      ...(0, _table_pagination.convertMetaToPagination)(enginesMeta),
      showPerPageOptions: false
    },
    onChange: (0, _table_pagination.handlePageChange)(onEnginesPagination)
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xxl"
  }), /*#__PURE__*/_react.default.createElement(_data_panel.DataPanel, {
    hasBorder: true,
    iconType: _icons.MetaEngineIcon,
    title: /*#__PURE__*/_react.default.createElement("h2", null, _constants.META_ENGINES_TITLE),
    titleSize: "s",
    action: canManageMetaEngines && /*#__PURE__*/_react.default.createElement(_react_router_helpers.EuiButtonTo, {
      color: "success",
      size: "s",
      iconType: "plusInCircle",
      "data-test-subj": "appSearchEnginesMetaEngineCreationButton",
      to: _routes.META_ENGINE_CREATION_PATH
    }, _constants.CREATE_A_META_ENGINE_BUTTON_LABEL),
    "data-test-subj": "appSearchMetaEngines"
  }, /*#__PURE__*/_react.default.createElement(_meta_engines_table.MetaEnginesTable, {
    items: metaEngines,
    loading: metaEnginesLoading,
    pagination: {
      ...(0, _table_pagination.convertMetaToPagination)(metaEnginesMeta),
      showPerPageOptions: false
    },
    noItemsMessage: /*#__PURE__*/_react.default.createElement(_components.EmptyMetaEnginesState, null),
    onChange: (0, _table_pagination.handlePageChange)(onMetaEnginesPagination)
  })), /*#__PURE__*/_react.default.createElement(_audit_logs_modal.AuditLogsModal, null));
};
exports.EnginesOverview = EnginesOverview;