"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetaEnginesTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _app_logic = require("../../../../app_logic");
var _audit_logs_modal_logic = require("../audit_logs_modal/audit_logs_modal_logic");
var _engine_link_helpers = require("./engine_link_helpers");
var _meta_engines_table_expanded_row = require("./meta_engines_table_expanded_row");
var _meta_engines_table_logic = require("./meta_engines_table_logic");
var _meta_engines_table_name_column_content = require("./meta_engines_table_name_column_content");
var _shared_columns = require("./shared_columns");
var _utils = require("./utils");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MetaEnginesTable = ({
  items,
  loading,
  noItemsMessage,
  pagination,
  onChange
}) => {
  const {
    expandedSourceEngines
  } = (0, _kea.useValues)(_meta_engines_table_logic.MetaEnginesTableLogic);
  const {
    hideRow,
    fetchOrDisplayRow
  } = (0, _kea.useActions)(_meta_engines_table_logic.MetaEnginesTableLogic);
  const {
    myRole: {
      canManageMetaEngines
    }
  } = (0, _kea.useValues)(_app_logic.AppLogic);
  const {
    showModal: showAuditLogModal
  } = (0, _kea.useActions)(_audit_logs_modal_logic.AuditLogsModalLogic);
  const conflictingEnginesSets = (0, _react.useMemo)(() => items.reduce((accumulator, metaEngine) => {
    return {
      ...accumulator,
      [metaEngine.name]: (0, _utils.getConflictingEnginesSet)(metaEngine)
    };
  }, {}), [items]);
  const itemIdToExpandedRowMap = (0, _react.useMemo)(() => Object.keys(expandedSourceEngines).reduce((accumulator, engineName) => {
    return {
      ...accumulator,
      [engineName]: /*#__PURE__*/_react.default.createElement(_meta_engines_table_expanded_row.MetaEnginesTableExpandedRow, {
        sourceEngines: expandedSourceEngines[engineName],
        conflictingEngines: conflictingEnginesSets[engineName]
      })
    };
  }, {}), [expandedSourceEngines, conflictingEnginesSets]);
  const columns = [{
    ..._shared_columns.NAME_COLUMN,
    render: (_, item) => /*#__PURE__*/_react.default.createElement(_meta_engines_table_name_column_content.MetaEnginesTableNameColumnContent, {
      item: item,
      isExpanded: !!itemIdToExpandedRowMap[item.name],
      hideRow: hideRow,
      showRow: fetchOrDisplayRow
    })
  }, _shared_columns.CREATED_AT_COLUMN, {
    ..._shared_columns.LAST_UPDATED_COLUMN,
    render: (dateString, engineDetails) => {
      return (0, _engine_link_helpers.renderLastChangeLink)(dateString, () => {
        showAuditLogModal(engineDetails.name);
      });
    }
  }, _shared_columns.BLANK_COLUMN, _shared_columns.DOCUMENT_COUNT_COLUMN, _shared_columns.FIELD_COUNT_COLUMN];
  if (canManageMetaEngines) {
    columns.push(_shared_columns.ACTIONS_COLUMN);
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    items: items,
    columns: columns,
    loading: loading,
    pagination: pagination,
    onChange: onChange,
    noItemsMessage: noItemsMessage,
    itemId: "name",
    itemIdToExpandedRowMap: itemIdToExpandedRowMap
  });
};
exports.MetaEnginesTable = MetaEnginesTable;