"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getEnginesDisplayText = void 0;
var _react = _interopRequireDefault(require("react"));
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getEnginesDisplayText = apiToken => {
  const {
    type,
    access_all_engines: accessAll,
    engines = []
  } = apiToken;
  if (type === _constants.ApiTokenTypes.Admin) {
    return '--';
  }
  if (accessAll) {
    return _constants.ALL;
  }
  return /*#__PURE__*/_react.default.createElement("ul", null, engines.map(engine => /*#__PURE__*/_react.default.createElement("li", {
    key: engine
  }, engine)));
};
exports.getEnginesDisplayText = getEnginesDisplayText;