"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AutomaticCrawlScheduler = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("../../../../../shared/constants");
var _units = require("../../../../../shared/constants/units");
var _routes = require("../../../../routes");
var _types = require("../../types");
var _automatic_crawl_scheduler_logic = require("./automatic_crawl_scheduler_logic");
var _manage_crawls_popover_logic = require("./manage_crawls_popover_logic");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AutomaticCrawlScheduler = () => {
  const {
    fetchCrawlSchedule,
    setCrawlFrequency,
    setCrawlUnit,
    saveChanges,
    toggleCrawlAutomatically
  } = (0, _kea.useActions)(_automatic_crawl_scheduler_logic.AutomaticCrawlSchedulerLogic);
  const {
    closePopover
  } = (0, _kea.useActions)(_manage_crawls_popover_logic.ManageCrawlsPopoverLogic);
  const {
    crawlAutomatically,
    crawlFrequency,
    crawlUnit,
    isSubmitting
  } = (0, _kea.useValues)(_automatic_crawl_scheduler_logic.AutomaticCrawlSchedulerLogic);
  (0, _react.useEffect)(() => {
    fetchCrawlSchedule();
  }, []);
  const formId = (0, _eui.htmlIdGenerator)('AutomaticCrawlScheduler')();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    onSubmit: event => {
      event.preventDefault();
      saveChanges();
    },
    component: "form",
    id: formId
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.appSearch.crawler.automaticCrawlSchedule.formDescription",
    defaultMessage: "Don't worry about it, we'll start a crawl for you. {readMoreMessage}.",
    values: {
      readMoreMessage: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: _routes.WEB_CRAWLER_DOCS_URL,
        target: "_blank"
      }, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.crawler.automaticCrawlSchedule.readMoreLink', {
        defaultMessage: 'Read more.'
      }))
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "rowCompressed"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    autoFocus: true,
    checked: crawlAutomatically,
    label: /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.crawler.automaticCrawlSchedule.crawlAutomaticallySwitchLabel', {
      defaultMessage: 'Crawl automatically'
    })),
    onChange: toggleCrawlAutomatically,
    compressed: true
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "rowCompressed"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "s",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.crawler.automaticCrawlSchedule.crawlUnitsPrefix', {
    defaultMessage: 'Every'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    "aria-label": _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.crawler.automaticCrawlSchedule.scheduleFrequencyLabel', {
      defaultMessage: 'Schedule frequency'
    }),
    disabled: !crawlAutomatically,
    fullWidth: false,
    min: 0,
    max: 99,
    compressed: true,
    value: crawlFrequency,
    onChange: e => setCrawlFrequency(parseInt(e.target.value, 10))
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    "aria-label": _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.crawler.automaticCrawlSchedule.scheduleUnitsLabel', {
      defaultMessage: 'Schedule units of time'
    }),
    disabled: !crawlAutomatically,
    compressed: true,
    options: [{
      text: _units.HOURS_UNIT_LABEL,
      value: _types.CrawlUnits.hours
    }, {
      text: _units.DAYS_UNIT_LABEL,
      value: _types.CrawlUnits.days
    }, {
      text: _units.WEEKS_UNIT_LABEL,
      value: _types.CrawlUnits.weeks
    }, {
      text: _units.MONTHS_UNIT_LABEL,
      value: _types.CrawlUnits.months
    }],
    value: crawlUnit,
    onChange: e => setCrawlUnit(e.target.value)
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued"
  }, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.crawler.automaticCrawlSchedule.scheduleDescription', {
    defaultMessage: 'The crawl schedule applies to every domain on this engine.'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "rowCompressed"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: closePopover
  }, _constants.CANCEL_BUTTON_LABEL)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    form: formId,
    type: "submit",
    isLoading: isSubmitting,
    fill: true
  }, _constants.SAVE_BUTTON_LABEL))))));
};
exports.AutomaticCrawlScheduler = AutomaticCrawlScheduler;