"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CrawlCustomSettingsFlyoutDomainsPanel = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _simplified_selectable = require("../crawl_select_domains_modal/simplified_selectable");
var _crawl_custom_settings_flyout_logic = require("./crawl_custom_settings_flyout_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CrawlCustomSettingsFlyoutDomainsPanel = () => {
  const {
    domainUrls,
    selectedDomainUrls
  } = (0, _kea.useValues)(_crawl_custom_settings_flyout_logic.CrawlCustomSettingsFlyoutLogic);
  const {
    onSelectDomainUrls
  } = (0, _kea.useActions)(_crawl_custom_settings_flyout_logic.CrawlCustomSettingsFlyoutLogic);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: (0, _eui.useGeneratedHtmlId)({
      prefix: 'domainAccordion'
    }),
    initialIsOpen: true,
    buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "row",
      responsive: false,
      gutterSize: "s",
      alignItems: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "globe"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement("h3", null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.crawler.crawlCustomSettingsFlyout.domainsAccordionButtonLabel', {
      defaultMessage: 'Add domains to your crawl'
    }))))),
    extraAction: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "m"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiNotificationBadge, {
      size: "m",
      color: selectedDomainUrls.length > 0 ? 'accent' : 'subdued'
    }, selectedDomainUrls.length), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.crawler.crawlCustomSettingsFlyout.selectedDescriptor', {
      defaultMessage: 'selected'
    })))
  }, /*#__PURE__*/_react.default.createElement(_simplified_selectable.SimplifiedSelectable, {
    options: domainUrls,
    selectedOptions: selectedDomainUrls,
    onChange: onSelectDomainUrls
  })));
};
exports.CrawlCustomSettingsFlyoutDomainsPanel = CrawlCustomSettingsFlyoutDomainsPanel;