"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ApiLogsTable = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _ = require("..");
var _table_pagination = require("../../../../shared/table_pagination");
var _api_log = require("../api_log");
var _utils = require("../utils");
var _2 = require(".");
require("./api_logs_table.scss");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ApiLogsTable = ({
  hasPagination
}) => {
  const {
    dataLoading,
    apiLogs,
    meta
  } = (0, _kea.useValues)(_.ApiLogsLogic);
  const {
    onPaginate
  } = (0, _kea.useActions)(_.ApiLogsLogic);
  const {
    openFlyout
  } = (0, _kea.useActions)(_api_log.ApiLogLogic);
  const columns = [{
    field: 'http_method',
    name: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.apiLogs.methodTableHeading', {
      defaultMessage: 'Method'
    }),
    width: '100px',
    render: method => /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "primary"
    }, method)
  }, {
    field: 'timestamp',
    name: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.apiLogs.timeTableHeading', {
      defaultMessage: 'Time'
    }),
    width: '20%',
    render: dateString => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedRelative, {
      value: new Date(dateString)
    })
  }, {
    field: 'full_request_path',
    name: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.apiLogs.endpointTableHeading', {
      defaultMessage: 'Endpoint'
    }),
    width: '50%',
    truncateText: true,
    mobileOptions: {
      // @ts-ignore - EUI's typing is incorrect here
      width: '100%'
    }
  }, {
    field: 'status',
    name: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.apiLogs.statusTableHeading', {
      defaultMessage: 'Status'
    }),
    dataType: 'number',
    width: '100px',
    render: status => /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
      color: (0, _utils.getStatusColor)(status)
    }, status)
  }, {
    width: '100px',
    align: 'right',
    render: apiLog => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      size: "s",
      className: "apiLogDetailButton",
      "data-test-subj": "ApiLogsTableDetailsButton",
      onClick: () => openFlyout(apiLog)
    }, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.apiLogs.detailsButtonLabel', {
      defaultMessage: 'Details'
    }))
  }];
  const paginationProps = hasPagination ? {
    pagination: {
      ...(0, _table_pagination.convertMetaToPagination)(meta),
      showPerPageOptions: false
    },
    onChange: (0, _table_pagination.handlePageChange)(onPaginate)
  } : {};
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, (0, _extends2.default)({
    columns: columns,
    items: apiLogs,
    responsive: true,
    loading: dataLoading,
    noItemsMessage: /*#__PURE__*/_react.default.createElement(_2.EmptyState, null)
  }, paginationProps));
};
exports.ApiLogsTable = ApiLogsTable;