"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ApiLogHeading = exports.ApiLogFlyout = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _utils = require("../utils");
var _ = require(".");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ApiLogFlyout = () => {
  const {
    isFlyoutOpen,
    apiLog
  } = (0, _kea.useValues)(_.ApiLogLogic);
  const {
    closeFlyout
  } = (0, _kea.useActions)(_.ApiLogLogic);
  if (!isFlyoutOpen) return null;
  if (!apiLog) return null;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    ownFocus: true,
    onClose: closeFlyout,
    "aria-labelledby": "apiLogFlyout"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: "apiLogFlyout"
  }, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.apiLogs.flyout.title', {
    defaultMessage: 'Request details'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(ApiLogHeading, null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.apiLogs.methodTitle', {
    defaultMessage: 'Method'
  })), /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "primary"
  }, apiLog.http_method))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(ApiLogHeading, null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.apiLogs.statusTitle', {
    defaultMessage: 'Status'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
    color: (0, _utils.getStatusColor)(apiLog.status)
  }, apiLog.status)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(ApiLogHeading, null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.apiLogs.timestampTitle', {
    defaultMessage: 'Timestamp'
  })), apiLog.timestamp)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(ApiLogHeading, null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.apiLogs.userAgentTitle', {
    defaultMessage: 'User agent'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, apiLog.user_agent)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(ApiLogHeading, null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.apiLogs.requestPathTitle', {
    defaultMessage: 'Request path'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, apiLog.full_request_path)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(ApiLogHeading, null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.apiLogs.requestBodyTitle', {
    defaultMessage: 'Request body'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "json",
    paddingSize: "m"
  }, (0, _utils.attemptToFormatJson)(apiLog.request_body)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(ApiLogHeading, null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.apiLogs.responseBodyTitle', {
    defaultMessage: 'Response body'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "json",
    paddingSize: "m"
  }, (0, _utils.attemptToFormatJson)(apiLog.response_body)))));
};
exports.ApiLogFlyout = ApiLogFlyout;
const ApiLogHeading = ({
  children
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
  size: "xs"
}, /*#__PURE__*/_react.default.createElement("h3", null, children));
exports.ApiLogHeading = ApiLogHeading;