"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnalyticsSearch = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _kibana = require("../../../../shared/kibana");
var _routes = require("../../../routes");
var _engine = require("../../engine");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AnalyticsSearch = () => {
  const [searchValue, setSearchValue] = (0, _react.useState)('');
  const {
    navigateToUrl
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  const viewQueryDetails = e => {
    e.preventDefault();
    const query = searchValue || '""';
    navigateToUrl((0, _engine.generateEnginePath)(_routes.ENGINE_ANALYTICS_QUERY_DETAIL_PATH, {
      query
    }));
  };
  return /*#__PURE__*/_react.default.createElement("form", {
    onSubmit: viewQueryDetails
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "m",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldSearch, {
    value: searchValue,
    onChange: e => setSearchValue(e.target.value),
    placeholder: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.analytics.queryDetailSearchPlaceholder', {
      defaultMessage: 'Go to search term'
    }),
    fullWidth: true
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    type: "submit"
  }, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.analytics.queryDetailSearchButtonLabel', {
    defaultMessage: 'View details'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null));
};
exports.AnalyticsSearch = AnalyticsSearch;