"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EnterpriseSearchAnalyticsPageTemplate = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _constants = require("../../../../../common/constants");
var _encode_path_params = require("../../../shared/encode_path_params");
var _kibana_chrome = require("../../../shared/kibana_chrome");
var _layout = require("../../../shared/layout");
var _nav = require("../../../shared/layout/nav");
var _telemetry = require("../../../shared/telemetry");
var _routes = require("../../routes");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EnterpriseSearchAnalyticsPageTemplate = ({
  children,
  analyticsName,
  pageChrome,
  pageViewTelemetry,
  ...pageTemplateProps
}) => {
  return /*#__PURE__*/_react.default.createElement(_layout.EnterpriseSearchPageTemplateWrapper, (0, _extends2.default)({}, pageTemplateProps, {
    solutionNav: {
      items: (0, _nav.useEnterpriseSearchAnalyticsNav)(analyticsName, analyticsName ? {
        explorer: (0, _encode_path_params.generateEncodedPath)(_routes.COLLECTION_EXPLORER_PATH, {
          name: analyticsName
        }),
        integration: (0, _encode_path_params.generateEncodedPath)(_routes.COLLECTION_INTEGRATE_PATH, {
          name: analyticsName
        }),
        overview: (0, _encode_path_params.generateEncodedPath)(_routes.COLLECTION_OVERVIEW_PATH, {
          name: analyticsName
        })
      } : undefined),
      name: _constants.ENTERPRISE_SEARCH_CONTENT_PLUGIN.NAME
    },
    setPageChrome: pageChrome && /*#__PURE__*/_react.default.createElement(_kibana_chrome.SetAnalyticsChrome, {
      trail: pageChrome
    })
  }), pageViewTelemetry && /*#__PURE__*/_react.default.createElement(_telemetry.SendEnterpriseSearchTelemetry, {
    action: "viewed",
    metric: pageViewTelemetry
  }), children);
};
exports.EnterpriseSearchAnalyticsPageTemplate = EnterpriseSearchAnalyticsPageTemplate;