"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnalyticsCollectionSettings = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _delete_analytics_collection_logic = require("./delete_analytics_collection_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AnalyticsCollectionSettings = ({
  collection
}) => {
  const {
    deleteAnalyticsCollection
  } = (0, _kea.useActions)(_delete_analytics_collection_logic.DeleteAnalyticsCollectionLogic);
  const {
    isLoading
  } = (0, _kea.useValues)(_delete_analytics_collection_logic.DeleteAnalyticsCollectionLogic);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    color: "subdued",
    paddingSize: "xl",
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    listItems: [{
      title: _i18n.i18n.translate('xpack.enterpriseSearch.analytics.collections.collectionsView.settingsTab.details.collectionName', {
        defaultMessage: 'Collection name'
      }),
      description: collection.name
    }, {
      title: _i18n.i18n.translate('xpack.enterpriseSearch.analytics.collections.collectionsView.settingsTab.details.eventsDataStreamName', {
        defaultMessage: 'Events Datastream Index'
      }),
      description: collection.events_datastream
    }],
    type: "column",
    align: "center"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    color: "danger",
    paddingSize: "l"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h4", null, _i18n.i18n.translate('xpack.enterpriseSearch.analytics.collections.collectionsView.settingsTab.delete.headingTitle', {
    defaultMessage: 'Delete this analytics collection'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.analytics.collections.collectionsView.settingsTab.delete.warning', {
    defaultMessage: 'This action is irreversible'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    type: "submit",
    color: "danger",
    isLoading: !isLoading,
    disabled: !isLoading,
    onClick: () => {
      deleteAnalyticsCollection(collection.name);
    }
  }, _i18n.i18n.translate('xpack.enterpriseSearch.analytics.collections.collectionsView.settingsTab.delete.buttonTitle', {
    defaultMessage: 'Delete this collection'
  }))));
};
exports.AnalyticsCollectionSettings = AnalyticsCollectionSettings;