"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnalyticsCollectionExplorer = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _i18n = require("@kbn/i18n");
var _page_template = require("../../layout/page_template");
var _analytics_collection_explore_table_logic = require("../analytics_collection_explore_table_logic");
var _analytics_collection_toolbar = require("../analytics_collection_toolbar/analytics_collection_toolbar");
var _fetch_analytics_collection_logic = require("../fetch_analytics_collection_logic");
var _analytics_collection_explorer_table = require("./analytics_collection_explorer_table");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AnalyticsCollectionExplorer = ({}) => {
  const {
    analyticsCollection
  } = (0, _kea.useValues)(_fetch_analytics_collection_logic.FetchAnalyticsCollectionLogic);
  const {
    reset
  } = (0, _kea.useActions)(_analytics_collection_explore_table_logic.AnalyticsCollectionExploreTableLogic);
  (0, _react.useEffect)(() => {
    return () => {
      reset();
    };
  }, []);
  return /*#__PURE__*/_react.default.createElement(_page_template.EnterpriseSearchAnalyticsPageTemplate, {
    restrictWidth: true,
    pageChrome: [analyticsCollection === null || analyticsCollection === void 0 ? void 0 : analyticsCollection.name],
    analyticsName: analyticsCollection === null || analyticsCollection === void 0 ? void 0 : analyticsCollection.name,
    pageViewTelemetry: `View Analytics Collection - explorer`,
    pageHeader: {
      bottomBorder: false,
      pageTitle: _i18n.i18n.translate('xpack.enterpriseSearch.analytics.collectionsView.explorerView.title', {
        defaultMessage: 'Explorer'
      }),
      rightSideItems: [/*#__PURE__*/_react.default.createElement(_analytics_collection_toolbar.AnalyticsCollectionToolbar, null)]
    }
  }, /*#__PURE__*/_react.default.createElement(_analytics_collection_explorer_table.AnalyticsCollectionExplorerTable, null));
};
exports.AnalyticsCollectionExplorer = AnalyticsCollectionExplorer;