"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HelloWorldContainerComponent = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _ = require("../..");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class HelloWorldContainerComponent extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "roots", {});
    (0, _defineProperty2.default)(this, "mounted", false);
    (0, _defineProperty2.default)(this, "inputSubscription", void 0);
    (0, _defineProperty2.default)(this, "outputSubscription", void 0);
    Object.values(this.props.container.getInput().panels).forEach(panelState => {
      this.roots[panelState.explicitInput.id] = /*#__PURE__*/_react.default.createRef();
    });
    this.state = {
      loaded: this.props.container.getOutput().embeddableLoaded,
      panels: this.props.container.getInput().panels
    };
  }
  async componentDidMount() {
    this.mounted = true;
    this.inputSubscription = this.props.container.getInput$().subscribe(() => {
      if (this.mounted) {
        this.setState({
          panels: this.props.container.getInput().panels
        });
      }
    });
    this.outputSubscription = this.props.container.getOutput$().subscribe(() => {
      if (this.mounted) {
        this.setState({
          loaded: this.props.container.getOutput().embeddableLoaded
        });
      }
    });
  }
  componentWillUnmount() {
    this.mounted = false;
    this.props.container.destroy();
    if (this.inputSubscription) {
      this.inputSubscription.unsubscribe();
    }
    if (this.outputSubscription) {
      this.outputSubscription.unsubscribe();
    }
  }
  render() {
    return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement("h2", null, "HELLO WORLD! These are my precious embeddable children:"), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, this.renderList()));
  }
  renderList() {
    const list = Object.values(this.state.panels).map(panelState => {
      const item = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        key: panelState.explicitInput.id
      }, /*#__PURE__*/_react.default.createElement(_.EmbeddableChildPanel, {
        container: this.props.container,
        embeddableId: panelState.explicitInput.id,
        PanelComponent: this.props.panelComponent
      }));
      return item;
    });
    return list;
  }
}
exports.HelloWorldContainerComponent = HelloWorldContainerComponent;