"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ACTION_SEND_MESSAGE = void 0;
exports.createSendMessageAction = createSendMessageAction;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _ui_actions = require("../../ui_actions");
var _get_message_modal = require("./get_message_modal");
var _say_hello_action = require("./say_hello_action");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const ACTION_SEND_MESSAGE = 'ACTION_SEND_MESSAGE';
exports.ACTION_SEND_MESSAGE = ACTION_SEND_MESSAGE;
const isCompatible = async context => (0, _say_hello_action.hasFullNameOutput)(context.embeddable);
function createSendMessageAction(overlays) {
  const sendMessage = async (context, message) => {
    const greeting = `Hello, ${context.embeddable.getOutput().fullName}`;
    const content = message ? `${greeting}. ${message}` : greeting;
    overlays.openFlyout((0, _public.toMountPoint)( /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, content)));
  };
  return (0, _ui_actions.createAction)({
    id: ACTION_SEND_MESSAGE,
    type: ACTION_SEND_MESSAGE,
    getDisplayName: () => 'Send message',
    isCompatible,
    execute: async context => {
      if (!(await isCompatible(context))) {
        throw new _ui_actions.IncompatibleActionError();
      }
      const modal = overlays.openModal((0, _public.toMountPoint)( /*#__PURE__*/_react.default.createElement(_get_message_modal.GetMessageModal, {
        onCancel: () => modal.close(),
        onDone: message => {
          modal.close();
          sendMessage(context, message);
        }
      })));
    }
  });
}