"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PanelOptionsMenu = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class PanelOptionsMenu extends _react.default.Component {
  static getDerivedStateFromProps(props, state) {
    if (props.closeContextMenu) {
      return {
        ...state,
        isPopoverOpen: false
      };
    } else {
      return state;
    }
  }
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "mounted", false);
    (0, _defineProperty2.default)(this, "closePopover", () => {
      if (this.mounted) {
        this.setState({
          isPopoverOpen: false
        });
      }
    });
    (0, _defineProperty2.default)(this, "toggleContextMenu", () => {
      if (!this.mounted) return;
      const after = () => {
        if (!this.state.isPopoverOpen) return;
        this.setState({
          actionContextMenuPanel: undefined
        });
        this.props.getActionContextMenuPanel().then(actionContextMenuPanel => {
          if (!this.mounted) return;
          this.setState({
            actionContextMenuPanel
          });
        }).catch(error => console.error(error)); // eslint-disable-line no-console
      };

      this.setState(({
        isPopoverOpen
      }) => ({
        isPopoverOpen: !isPopoverOpen
      }), after);
    });
    this.state = {
      actionContextMenuPanel: undefined,
      isPopoverOpen: false,
      showNotification: false
    };
  }
  async componentDidMount() {
    this.mounted = true;
    this.setState({
      actionContextMenuPanel: undefined
    });
    const actionContextMenuPanel = await this.props.getActionContextMenuPanel();
    const showNotification = actionContextMenuPanel.actions.some(action => action.showNotification);
    if (this.mounted) {
      this.setState({
        actionContextMenuPanel,
        showNotification
      });
    }
  }
  async componentDidUpdate() {
    const actionContextMenuPanel = await this.props.getActionContextMenuPanel();
    const showNotification = actionContextMenuPanel.actions.some(action => action.showNotification);
    if (this.mounted && this.state.showNotification !== showNotification) {
      this.setState({
        showNotification
      });
    }
  }
  componentWillUnmount() {
    this.mounted = false;
  }
  render() {
    var _this$state$actionCon;
    const {
      isViewMode,
      title,
      index
    } = this.props;
    const enhancedAriaLabel = _i18n.i18n.translate('embeddableApi.panel.optionsMenu.panelOptionsButtonEnhancedAriaLabel', {
      defaultMessage: 'Panel options for {title}',
      values: {
        title
      }
    });
    const ariaLabelWithoutTitle = index === undefined ? _i18n.i18n.translate('embeddableApi.panel.optionsMenu.panelOptionsButtonAriaLabel', {
      defaultMessage: 'Panel options'
    }) : _i18n.i18n.translate('embeddableApi.panel.optionsMenu.panelOptionsButtonAriaLabelWithIndex', {
      defaultMessage: 'Options for panel {index}',
      values: {
        index
      }
    });
    const button = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      iconType: isViewMode ? 'boxesHorizontal' : 'gear',
      color: "text",
      className: "embPanel__optionsMenuButton",
      "aria-label": title ? enhancedAriaLabel : ariaLabelWithoutTitle,
      "data-test-subj": "embeddablePanelToggleMenuIcon",
      onClick: this.toggleContextMenu
    });
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
      className: 'embPanel__optionsMenuPopover' + (this.state.showNotification ? ' embPanel__optionsMenuPopover-notification' : ''),
      button: button,
      isOpen: this.state.isPopoverOpen,
      closePopover: this.closePopover,
      panelPaddingSize: "none",
      anchorPosition: "downRight",
      "data-test-subj": this.state.isPopoverOpen ? 'embeddablePanelContextMenuOpen' : 'embeddablePanelContextMenuClosed',
      repositionOnScroll: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
      initialPanelId: "mainMenu",
      panels: ((_this$state$actionCon = this.state.actionContextMenuPanel) === null || _this$state$actionCon === void 0 ? void 0 : _this$state$actionCon.panels) || []
    }));
  }
}
exports.PanelOptionsMenu = PanelOptionsMenu;