"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getUnallowedFieldValuesRoute = void 0;
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _lib = require("../lib");
var _build_response = require("../lib/build_response");
var _constants = require("../../common/constants");
var _common = require("../schemas/common");
var _get_unallowed_field_values = require("../schemas/get_unallowed_field_values");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getUnallowedFieldValuesRoute = router => {
  router.post({
    path: _constants.GET_UNALLOWED_FIELD_VALUES,
    validate: {
      body: (0, _common.buildRouteValidation)(_get_unallowed_field_values.GetUnallowedFieldValuesBody)
    }
  }, async (context, request, response) => {
    const resp = (0, _build_response.buildResponse)(response);
    const esClient = (await context.core).elasticsearch.client.asCurrentUser;
    try {
      const items = request.body;
      const {
        responses
      } = await (0, _lib.getUnallowedFieldValues)(esClient, items);
      return response.ok({
        body: responses
      });
    } catch (err) {
      const error = (0, _securitysolutionEsUtils.transformError)(err);
      return resp.error({
        body: error.message,
        statusCode: error.statusCode
      });
    }
  });
};
exports.getUnallowedFieldValuesRoute = getUnallowedFieldValuesRoute;