"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getUrlTracking = void 0;
exports.initializeKbnUrlTracking = initializeKbnUrlTracking;
exports.setUrlTracking = void 0;
var _operators = require("rxjs/operators");
var _public = require("@kbn/kibana-utils-plugin/public");
var _common = require("@kbn/kibana-utils-plugin/common");
var _kibana_services = require("../kibana_services");
var _constants = require("../constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/**
 * Store the setting of enabling / disabling url
 * it's should be disabled for ad-hoc data views to omit error messages
 * - When you've added an ad hoc data view in Discover
 * - Continued your work in different parts of Kibana
 * - You've closed the Kibana tab
 */
const [getUrlTracking, setUrlTracking] = (0, _public.createGetterSetter)('urlTrackingEnabled');
/**
 * It creates the kbn url tracker for Discover to listens to history changes and optionally to global state
 * changes and updates the nav link url of to point to the last visited page
 */
exports.setUrlTracking = setUrlTracking;
exports.getUrlTracking = getUrlTracking;
function initializeKbnUrlTracking(baseUrl, core, navLinkUpdater$, plugins) {
  setUrlTracking({
    enabled: true
  });
  const setTrackingEnabled = value => {
    setUrlTracking({
      enabled: value
    });
  };
  const {
    appMounted,
    appUnMounted,
    stop: stopUrlTracker,
    setActiveUrl: setTrackedUrl,
    restorePreviousUrl
  } = (0, _public.createKbnUrlTracker)({
    // we pass getter here instead of plain `history`,
    // so history is lazily created (when app is mounted)
    // this prevents redundant `#` when not in discover app
    getHistory: _kibana_services.getScopedHistory,
    baseUrl,
    defaultSubUrl: '#/',
    storageKey: `lastUrl:${core.http.basePath.get()}:discover`,
    navLinkUpdater$,
    toastNotifications: core.notifications.toasts,
    stateParams: [{
      kbnUrlKey: '_g',
      stateUpdate$: plugins.data.query.state$.pipe((0, _operators.filter)(({
        changes
      }) => !!(changes.globalFilters || changes.time || changes.refreshInterval)), (0, _operators.map)(async ({
        state
      }) => {
        var _state$filters;
        const {
          isFilterPinned
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('@kbn/es-query')));
        return {
          ...state,
          filters: (_state$filters = state.filters) === null || _state$filters === void 0 ? void 0 : _state$filters.filter(isFilterPinned)
        };
      }))
    }],
    shouldTrackUrlUpdate: () => {
      return getUrlTracking().enabled;
    },
    onBeforeNavLinkSaved: newNavLink => {
      // Do not save SEARCH_SESSION_ID into nav link, because of possible edge cases
      // that could lead to session restoration failure.
      // see: https://github.com/elastic/kibana/issues/87149
      if (newNavLink.includes(_constants.SEARCH_SESSION_ID_QUERY_PARAM)) {
        newNavLink = (0, _common.replaceUrlHashQuery)(newNavLink, query => {
          delete query[_constants.SEARCH_SESSION_ID_QUERY_PARAM];
          return query;
        });
      }
      return newNavLink;
    }
  });
  return {
    appMounted,
    appUnMounted,
    stopUrlTracker,
    setTrackedUrl,
    restorePreviousUrl,
    setTrackingEnabled
  };
}