"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.formatFieldValue = formatFieldValue;
var _public = require("@kbn/data-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Formats the value of a specific field using the appropriate field formatter if available
 * or the default string field formatter otherwise.
 *
 * @param value The value to format
 * @param hit The actual search hit (required to get highlight information from)
 * @param fieldFormats Field formatters
 * @param dataView The data view if available
 * @param field The field that value was from if available
 * @param contentType Type of a converter
 * @param options Options for the converter
 * @returns An sanitized HTML string, that is safe to be applied via dangerouslySetInnerHTML
 */
function formatFieldValue(value, hit, fieldFormats, dataView, field, contentType, options) {
  const usedContentType = contentType !== null && contentType !== void 0 ? contentType : 'html';
  const converterOptions = {
    hit,
    field,
    ...options
  };
  if (!dataView || !field) {
    // If either no field is available or no data view, we'll use the default
    // string formatter to format that field.
    return fieldFormats.getDefaultInstance(_public.KBN_FIELD_TYPES.STRING).convert(value, usedContentType, converterOptions);
  }

  // If we have a data view and field we use that fields field formatter
  return dataView.getFormatterForField(field).convert(value, usedContentType, converterOptions);
}