"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DocViewTableRowBtnCollapse = DocViewTableRowBtnCollapse;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function DocViewTableRowBtnCollapse({
  onClick,
  isCollapsed
}) {
  const label = _i18n.i18n.translate('discover.docViews.table.toggleFieldDetails', {
    defaultMessage: 'Toggle field details'
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: label
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "aria-expanded": !isCollapsed,
    "aria-label": label,
    "data-test-subj": "collapseBtn",
    onClick: () => onClick(),
    iconType: isCollapsed ? 'arrowRight' : 'arrowDown',
    iconSize: 's'
  }));
}