"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createProfileRegistry = exports.createCustomizeFunction = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const createProfileRegistry = () => {
  const profiles = new Map();
  return {
    get: name => profiles.get(name.toLowerCase()),
    set: profile => profiles.set(profile.name.toLowerCase(), profile)
  };
};
exports.createProfileRegistry = createProfileRegistry;
const createCustomizeFunction = profileRegistry => (profileName, callback) => {
  var _profileRegistry$get;
  const profile = (_profileRegistry$get = profileRegistry.get(profileName)) !== null && _profileRegistry$get !== void 0 ? _profileRegistry$get : {
    name: profileName,
    customizationCallbacks: []
  };
  profile.customizationCallbacks.push(callback);
  profileRegistry.set(profile);
};
exports.createCustomizeFunction = createCustomizeFunction;