"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DocumentViewModeToggle = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _react2 = require("@emotion/react");
var _uiTheme = require("@kbn/ui-theme");
var _constants = require("../../../common/constants");
var _common = require("../../../common");
var _use_discover_services = require("../../hooks/use_discover_services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const DocumentViewModeToggle = ({
  viewMode,
  setDiscoverViewMode
}) => {
  var _uiSettings$get;
  const {
    uiSettings
  } = (0, _use_discover_services.useDiscoverServices)();
  const tabsCss = (0, _react2.css)`
    padding: 0 ${(0, _eui.useEuiPaddingSize)('s')};
    background-color: ${_uiTheme.euiThemeVars.euiPageBackgroundColor};
  `;
  const showViewModeToggle = (_uiSettings$get = uiSettings.get(_common.SHOW_FIELD_STATISTICS)) !== null && _uiSettings$get !== void 0 ? _uiSettings$get : false;
  if (!showViewModeToggle) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, {
    size: "s",
    css: tabsCss,
    "data-test-subj": "dscViewModeToggle"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    isSelected: viewMode === _constants.VIEW_MODE.DOCUMENT_LEVEL,
    onClick: () => setDiscoverViewMode(_constants.VIEW_MODE.DOCUMENT_LEVEL),
    className: "dscViewModeToggle__tab",
    "data-test-subj": "dscViewModeDocumentButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "discover.viewModes.document.label",
    defaultMessage: "Documents"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    isSelected: viewMode === _constants.VIEW_MODE.AGGREGATED_LEVEL,
    onClick: () => setDiscoverViewMode(_constants.VIEW_MODE.AGGREGATED_LEVEL),
    className: "dscViewModeToggle__tab",
    "data-test-subj": "dscViewModeFieldStatsButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "discover.viewModes.fieldStatistics.label",
    defaultMessage: "Field statistics"
  })));
};
exports.DocumentViewModeToggle = DocumentViewModeToggle;