"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldName = FieldName;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
require("./field_name.scss");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _reactField = require("@kbn/react-field");
var _public = require("@kbn/data-views-plugin/public");
var _public2 = require("@kbn/unified-field-list-plugin/public");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function FieldName({
  fieldName,
  fieldMapping,
  fieldType,
  fieldIconProps,
  scripted = false,
  highlight = ''
}) {
  const typeName = (0, _public2.getFieldTypeName)(fieldType);
  const displayName = fieldMapping && fieldMapping.displayName ? fieldMapping.displayName : fieldName;
  const tooltip = displayName !== fieldName ? `${fieldName} (${displayName})` : fieldName;
  const subTypeMulti = fieldMapping && (0, _public.getFieldSubtypeMulti)(fieldMapping.spec);
  const isMultiField = !!(subTypeMulti !== null && subTypeMulti !== void 0 && subTypeMulti.multi);
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    className: "kbnDocViewer__fieldIcon"
  }, /*#__PURE__*/_react.default.createElement(_reactField.FieldIcon, (0, _extends2.default)({
    type: fieldType,
    label: typeName,
    scripted: scripted
  }, fieldIconProps))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    wrap: true,
    gutterSize: "none",
    responsive: false,
    alignItems: "flexStart"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    className: "kbnDocViewer__fieldName eui-textBreakAll",
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: tooltip,
    delay: "long",
    anchorClassName: "eui-textBreakAll"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHighlight, {
    search: highlight
  }, displayName))), isMultiField && /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    delay: "long",
    content: _i18n.i18n.translate('discover.fieldChooser.discoverField.multiFieldTooltipContent', {
      defaultMessage: 'Multi-fields can have multiple values per field'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    title: "",
    className: "kbnDocViewer__multiFieldBadge",
    color: "default",
    "data-test-subj": `tableDocViewRow-${fieldName}-multifieldBadge`
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "discover.fieldChooser.discoverField.multiField",
    defaultMessage: "multi-field"
  })))));
}