"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiDataGridMemoized = exports.DiscoverGrid = void 0;
var _react = _interopRequireWildcard(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _i18nReact = require("@kbn/i18n-react");
var _rxjs = require("rxjs");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
require("./discover_grid.scss");
var _eui = require("@elastic/eui");
var _discover_grid_schema = require("./discover_grid_schema");
var _discover_grid_context = require("./discover_grid_context");
var _get_render_cell_value = require("./get_render_cell_value");
var _discover_grid_columns = require("./discover_grid_columns");
var _constants = require("./constants");
var _columns = require("../../utils/columns");
var _common = require("../../../common");
var _discover_grid_document_selection = require("./discover_grid_document_selection");
var _get_should_show_field_handler = require("../../utils/get_should_show_field_handler");
var _use_row_heights_options = require("../../hooks/use_row_heights_options");
var _convert_value_to_string = require("../../utils/convert_value_to_string");
var _rows_per_page = require("../../utils/rows_per_page");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const themeDefault = {
  darkMode: false
};
const EuiDataGridMemoized = /*#__PURE__*/_react.default.memo(_eui.EuiDataGrid);
exports.EuiDataGridMemoized = EuiDataGridMemoized;
const CONTROL_COLUMN_IDS_DEFAULT = ['openDetails', 'select'];
const DiscoverGrid = ({
  ariaLabelledBy,
  columns,
  dataView,
  isLoading,
  expandedDoc,
  onAddColumn,
  filters,
  query,
  savedSearchId,
  onFilter,
  onRemoveColumn,
  onResize,
  onSetColumns,
  onSort,
  rows,
  sampleSize,
  searchDescription,
  searchTitle,
  setExpandedDoc,
  settings,
  showTimeCol,
  showFullScreenButton = true,
  sort,
  useNewFieldsApi,
  isSortEnabled = true,
  isPaginationEnabled = true,
  controlColumnIds = CONTROL_COLUMN_IDS_DEFAULT,
  className,
  rowHeightState,
  onUpdateRowHeight,
  isPlainRecord = false,
  rowsPerPageState,
  onUpdateRowsPerPage,
  onFieldEdited,
  DocumentView,
  services
}) => {
  var _services$core$theme$, _services$core$theme;
  const {
    fieldFormats,
    toastNotifications,
    dataViewFieldEditor,
    uiSettings
  } = services;
  const {
    darkMode
  } = (0, _useObservable.default)((_services$core$theme$ = (_services$core$theme = services.core.theme) === null || _services$core$theme === void 0 ? void 0 : _services$core$theme.theme$) !== null && _services$core$theme$ !== void 0 ? _services$core$theme$ : (0, _rxjs.of)(themeDefault), themeDefault);
  const dataGridRef = (0, _react.useRef)(null);
  const [selectedDocs, setSelectedDocs] = (0, _react.useState)([]);
  const [isFilterActive, setIsFilterActive] = (0, _react.useState)(false);
  const displayedColumns = (0, _columns.getDisplayedColumns)(columns, dataView);
  const defaultColumns = displayedColumns.includes('_source');
  const usedSelectedDocs = (0, _react.useMemo)(() => {
    if (!selectedDocs.length || !(rows !== null && rows !== void 0 && rows.length)) {
      return [];
    }
    const idMap = rows.reduce((map, row) => map.set(row.id, true), new Map());
    // filter out selected docs that are no longer part of the current data
    const result = selectedDocs.filter(docId => idMap.get(docId));
    if (result.length === 0 && isFilterActive) {
      setIsFilterActive(false);
    }
    return result;
  }, [selectedDocs, rows, isFilterActive]);
  const displayedRows = (0, _react.useMemo)(() => {
    if (!rows) {
      return [];
    }
    if (!isFilterActive || usedSelectedDocs.length === 0) {
      return rows;
    }
    const rowsFiltered = rows.filter(row => usedSelectedDocs.includes(row.id));
    if (!rowsFiltered.length) {
      // in case the selected docs are no longer part of the sample of 500, show all docs
      return rows;
    }
    return rowsFiltered;
  }, [rows, usedSelectedDocs, isFilterActive]);
  const valueToStringConverter = (0, _react.useCallback)((rowIndex, columnId, options) => {
    return (0, _convert_value_to_string.convertValueToString)({
      rowIndex,
      rows: displayedRows,
      dataView,
      columnId,
      fieldFormats,
      options
    });
  }, [displayedRows, dataView, fieldFormats]);

  /**
   * Pagination
   */
  const defaultRowsPerPage = (0, _react.useMemo)(() => (0, _rows_per_page.getDefaultRowsPerPage)(services.uiSettings), [services.uiSettings]);
  const currentPageSize = typeof rowsPerPageState === 'number' && rowsPerPageState > 0 ? rowsPerPageState : defaultRowsPerPage;
  const [pagination, setPagination] = (0, _react.useState)({
    pageIndex: 0,
    pageSize: currentPageSize
  });
  const rowCount = (0, _react.useMemo)(() => displayedRows ? displayedRows.length : 0, [displayedRows]);
  const pageCount = (0, _react.useMemo)(() => Math.ceil(rowCount / pagination.pageSize), [rowCount, pagination]);
  const paginationObj = (0, _react.useMemo)(() => {
    const onChangeItemsPerPage = pageSize => {
      onUpdateRowsPerPage === null || onUpdateRowsPerPage === void 0 ? void 0 : onUpdateRowsPerPage(pageSize);
    };
    const onChangePage = pageIndex => setPagination(paginationData => ({
      ...paginationData,
      pageIndex
    }));
    return isPaginationEnabled ? {
      onChangeItemsPerPage,
      onChangePage,
      pageIndex: pagination.pageIndex > pageCount - 1 ? 0 : pagination.pageIndex,
      pageSize: pagination.pageSize,
      pageSizeOptions: (0, _rows_per_page.getRowsPerPageOptions)(pagination.pageSize)
    } : undefined;
  }, [pagination, pageCount, isPaginationEnabled, onUpdateRowsPerPage]);
  const isOnLastPage = paginationObj ? paginationObj.pageIndex === pageCount - 1 : false;
  (0, _react.useEffect)(() => {
    setPagination(paginationData => paginationData.pageSize === currentPageSize ? paginationData : {
      ...paginationData,
      pageSize: currentPageSize
    });
  }, [currentPageSize, setPagination]);

  /**
   * Sorting
   */
  const sortingColumns = (0, _react.useMemo)(() => sort.map(([id, direction]) => ({
    id,
    direction
  })), [sort]);
  const [inmemorySortingColumns, setInmemorySortingColumns] = (0, _react.useState)([]);
  const onTableSort = (0, _react.useCallback)(sortingColumnsData => {
    if (isSortEnabled) {
      if (isPlainRecord) {
        setInmemorySortingColumns(sortingColumnsData);
      } else if (onSort) {
        onSort(sortingColumnsData.map(({
          id,
          direction
        }) => [id, direction]));
      }
    }
  }, [onSort, isSortEnabled, isPlainRecord, setInmemorySortingColumns]);
  const showMultiFields = services.uiSettings.get(_common.SHOW_MULTIFIELDS);
  const shouldShowFieldHandler = (0, _react.useMemo)(() => {
    const dataViewFields = dataView.fields.getAll().map(fld => fld.name);
    return (0, _get_should_show_field_handler.getShouldShowFieldHandler)(dataViewFields, dataView, showMultiFields);
  }, [dataView, showMultiFields]);

  /**
   * Cell rendering
   */
  const renderCellValue = (0, _react.useMemo)(() => (0, _get_render_cell_value.getRenderCellValueFn)(dataView, displayedRows, useNewFieldsApi, shouldShowFieldHandler, services.uiSettings.get(_common.MAX_DOC_FIELDS_DISPLAYED), () => {
    var _dataGridRef$current;
    return (_dataGridRef$current = dataGridRef.current) === null || _dataGridRef$current === void 0 ? void 0 : _dataGridRef$current.closeCellPopover();
  }), [dataView, displayedRows, useNewFieldsApi, shouldShowFieldHandler, services.uiSettings]);

  /**
   * Render variables
   */
  const showDisclaimer = rowCount === sampleSize && isOnLastPage;
  const randomId = (0, _react.useMemo)(() => (0, _eui.htmlIdGenerator)()(), []);
  const closeFieldEditor = (0, _react.useRef)();
  (0, _react.useEffect)(() => {
    return () => {
      if (closeFieldEditor !== null && closeFieldEditor !== void 0 && closeFieldEditor.current) {
        closeFieldEditor === null || closeFieldEditor === void 0 ? void 0 : closeFieldEditor.current();
      }
    };
  }, []);
  const editField = (0, _react.useMemo)(() => onFieldEdited ? fieldName => {
    closeFieldEditor.current = services.dataViewFieldEditor.openEditor({
      ctx: {
        dataView
      },
      fieldName,
      onSave: async () => {
        await onFieldEdited();
      }
    });
  } : undefined, [dataView, onFieldEdited, services.dataViewFieldEditor]);
  const euiGridColumns = (0, _react.useMemo)(() => (0, _discover_grid_columns.getEuiGridColumns)({
    columns: displayedColumns,
    rowsCount: displayedRows.length,
    settings,
    dataView,
    showTimeCol,
    defaultColumns,
    isSortEnabled,
    isPlainRecord,
    services: {
      uiSettings,
      toastNotifications
    },
    hasEditDataViewPermission: () => dataViewFieldEditor.userPermissions.editIndexPattern(),
    valueToStringConverter,
    onFilter,
    editField
  }), [onFilter, displayedColumns, displayedRows, dataView, showTimeCol, settings, defaultColumns, isSortEnabled, isPlainRecord, uiSettings, toastNotifications, dataViewFieldEditor, valueToStringConverter, editField]);
  const hideTimeColumn = (0, _react.useMemo)(() => services.uiSettings.get(_common.DOC_HIDE_TIME_COLUMN_SETTING, false), [services.uiSettings]);
  const schemaDetectors = (0, _react.useMemo)(() => (0, _discover_grid_schema.getSchemaDetectors)(), []);
  const columnsVisibility = (0, _react.useMemo)(() => ({
    visibleColumns: (0, _discover_grid_columns.getVisibleColumns)(displayedColumns, dataView, showTimeCol),
    setVisibleColumns: newColumns => {
      onSetColumns(newColumns, hideTimeColumn);
    }
  }), [displayedColumns, dataView, showTimeCol, hideTimeColumn, onSetColumns]);
  const sorting = (0, _react.useMemo)(() => {
    if (isSortEnabled) {
      return {
        columns: isPlainRecord ? inmemorySortingColumns : sortingColumns,
        onSort: onTableSort
      };
    }
    return {
      columns: sortingColumns,
      onSort: () => {}
    };
  }, [isSortEnabled, sortingColumns, isPlainRecord, inmemorySortingColumns, onTableSort]);
  const canSetExpandedDoc = Boolean(setExpandedDoc && DocumentView);
  const lead = (0, _react.useMemo)(() => (0, _discover_grid_columns.getLeadControlColumns)(canSetExpandedDoc).filter(({
    id
  }) => controlColumnIds.includes(id)), [controlColumnIds, canSetExpandedDoc]);
  const additionalControls = (0, _react.useMemo)(() => usedSelectedDocs.length ? /*#__PURE__*/_react.default.createElement(_discover_grid_document_selection.DiscoverGridDocumentToolbarBtn, {
    isFilterActive: isFilterActive,
    rows: rows,
    selectedDocs: usedSelectedDocs,
    setSelectedDocs: setSelectedDocs,
    setIsFilterActive: setIsFilterActive
  }) : null, [usedSelectedDocs, isFilterActive, rows, setIsFilterActive]);
  const showDisplaySelector = (0, _react.useMemo)(() => !!onUpdateRowHeight ? {
    allowDensity: false,
    allowRowHeight: true
  } : undefined, [onUpdateRowHeight]);
  const inMemory = (0, _react.useMemo)(() => {
    return isPlainRecord ? {
      level: 'sorting'
    } : undefined;
  }, [isPlainRecord]);
  const toolbarVisibility = (0, _react.useMemo)(() => defaultColumns ? {
    ..._constants.toolbarVisibility,
    showColumnSelector: false,
    showSortSelector: isSortEnabled,
    additionalControls,
    showDisplaySelector,
    showFullScreenSelector: showFullScreenButton
  } : {
    ..._constants.toolbarVisibility,
    showSortSelector: isSortEnabled,
    additionalControls,
    showDisplaySelector,
    showFullScreenSelector: showFullScreenButton
  }, [defaultColumns, isSortEnabled, additionalControls, showDisplaySelector, showFullScreenButton]);
  const rowHeightsOptions = (0, _use_row_heights_options.useRowHeightsOptions)({
    rowHeightState,
    onUpdateRowHeight
  });
  if (!rowCount && isLoading) {
    return /*#__PURE__*/_react.default.createElement("div", {
      className: "euiDataGrid__loading"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      color: "subdued"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "discover.loadingResults",
      defaultMessage: "Loading results"
    })));
  }
  if (!rowCount) {
    return /*#__PURE__*/_react.default.createElement("div", {
      className: "euiDataGrid__noResults",
      "data-render-complete": !isLoading,
      "data-shared-item": "",
      "data-title": searchTitle,
      "data-description": searchDescription,
      "data-document-number": 0
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      color: "subdued"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "discoverApp",
      size: "m",
      color: "subdued"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "discover.noResultsFound",
      defaultMessage: "No results found"
    })));
  }
  return /*#__PURE__*/_react.default.createElement(_discover_grid_context.DiscoverGridContext.Provider, {
    value: {
      expanded: expandedDoc,
      setExpanded: setExpandedDoc,
      rows: displayedRows,
      onFilter,
      dataView,
      isDarkMode: darkMode,
      selectedDocs: usedSelectedDocs,
      setSelectedDocs: newSelectedDocs => {
        setSelectedDocs(newSelectedDocs);
        if (isFilterActive && newSelectedDocs.length === 0) {
          setIsFilterActive(false);
        }
      },
      valueToStringConverter
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    className: "dscDiscoverGrid__inner"
  }, /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "discoverDocTable",
    "data-render-complete": !isLoading,
    "data-shared-item": "",
    "data-title": searchTitle,
    "data-description": searchDescription,
    "data-document-number": displayedRows.length,
    className: (0, _classnames.default)(className, 'dscDiscoverGrid__table')
  }, /*#__PURE__*/_react.default.createElement(EuiDataGridMemoized, {
    "aria-describedby": randomId,
    "aria-labelledby": ariaLabelledBy,
    columns: euiGridColumns,
    columnVisibility: columnsVisibility,
    "data-test-subj": "docTable",
    leadingControlColumns: lead,
    onColumnResize: onResize,
    pagination: paginationObj,
    renderCellValue: renderCellValue,
    ref: dataGridRef,
    rowCount: rowCount,
    schemaDetectors: schemaDetectors,
    sorting: sorting,
    toolbarVisibility: toolbarVisibility,
    rowHeightsOptions: rowHeightsOptions,
    inMemory: inMemory,
    gridStyle: _constants.GRID_STYLE
  })), showDisclaimer && /*#__PURE__*/_react.default.createElement("p", {
    className: "dscDiscoverGrid__footer",
    "data-test-subj": "discoverTableFooter"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "discover.gridSampleSize.limitDescription",
    defaultMessage: "Search results are limited to {sampleSize} documents. Add more search terms to narrow your search.",
    values: {
      sampleSize
    }
  })), searchTitle && /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, null, /*#__PURE__*/_react.default.createElement("p", {
    id: String(randomId)
  }, searchDescription ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "discover.searchGenerationWithDescriptionGrid",
    defaultMessage: "Table generated by search {searchTitle} ({searchDescription})",
    values: {
      searchTitle,
      searchDescription
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "discover.searchGenerationWithDescription",
    defaultMessage: "Table generated by search {searchTitle}",
    values: {
      searchTitle
    }
  }))), setExpandedDoc && expandedDoc && DocumentView && /*#__PURE__*/_react.default.createElement(DocumentView, {
    dataView: dataView,
    hit: expandedDoc,
    hits: displayedRows
    // if default columns are used, dont make them part of the URL - the context state handling will take care to restore them
    ,
    columns: defaultColumns ? [] : displayedColumns,
    filters: filters,
    savedSearchId: savedSearchId,
    onFilter: onFilter,
    onRemoveColumn: onRemoveColumn,
    onAddColumn: onAddColumn,
    onClose: () => setExpandedDoc(undefined),
    setExpandedDoc: setExpandedDoc,
    query: query
  })));
};
exports.DiscoverGrid = DiscoverGrid;