"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ResetSearchButton = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react2 = require("@emotion/react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const resetSearchButtonWrapper = (0, _react2.css)`
  overflow: hidden;
`;
const ResetSearchButton = ({
  resetSavedSearch
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: resetSearchButtonWrapper
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "refresh",
    "data-test-subj": "resetSavedSearch",
    onClick: resetSavedSearch,
    size: "s",
    "aria-label": _i18n.i18n.translate('discover.reloadSavedSearchButton', {
      defaultMessage: 'Reset search'
    })
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "discover.reloadSavedSearchButton",
    defaultMessage: "Reset search"
  })));
};
exports.ResetSearchButton = ResetSearchButton;