"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchPanel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _mlIsDefined = require("@kbn/ml-is-defined");
var _field_name_filter = require("./field_name_filter");
var _field_type_filter = require("./field_type_filter");
var _kibana_context = require("../../../kibana_context");
var _saved_search_utils = require("../../utils/saved_search_utils");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SearchPanel = ({
  dataView,
  searchString,
  searchQueryLanguage,
  overallStats,
  indexedFieldTypes,
  setVisibleFieldTypes,
  visibleFieldTypes,
  setVisibleFieldNames,
  visibleFieldNames,
  setSearchParams,
  showEmptyFields
}) => {
  const {
    services: {
      uiSettings,
      notifications: {
        toasts
      },
      data: {
        query: queryManager
      },
      unifiedSearch: {
        ui: {
          SearchBar
        }
      }
    }
  } = (0, _kibana_context.useDataVisualizerKibana)();
  // The internal state of the input query bar updated on every key stroke.
  const [searchInput, setSearchInput] = (0, _react.useState)({
    query: searchString || '',
    language: searchQueryLanguage
  });
  (0, _react.useEffect)(() => {
    setSearchInput({
      query: searchString || '',
      language: searchQueryLanguage
    });
  }, [searchQueryLanguage, searchString, queryManager.filterManager]);
  const searchHandler = ({
    query,
    filters
  }) => {
    const mergedQuery = (0, _mlIsDefined.isDefined)(query) ? query : searchInput;
    const mergedFilters = (0, _mlIsDefined.isDefined)(filters) ? filters : queryManager.filterManager.getFilters();
    try {
      var _queryManager$filterM;
      if (mergedFilters) {
        queryManager.filterManager.setFilters(mergedFilters);
      }
      const combinedQuery = (0, _saved_search_utils.createMergedEsQuery)(mergedQuery, (_queryManager$filterM = queryManager.filterManager.getFilters()) !== null && _queryManager$filterM !== void 0 ? _queryManager$filterM : [], dataView, uiSettings);
      setSearchParams({
        searchQuery: combinedQuery,
        searchString: mergedQuery.query,
        queryLanguage: mergedQuery.language,
        filters: mergedFilters
      });
    } catch (e) {
      console.log('Invalid syntax', JSON.stringify(e, null, 2)); // eslint-disable-line no-console
      toasts.addError(e, {
        title: _i18n.i18n.translate('xpack.dataVisualizer.searchPanel.invalidSyntax', {
          defaultMessage: 'Invalid syntax'
        })
      });
    }
  };
  const dvSearchPanelControls = (0, _react2.css)({
    marginLeft: '0px !important',
    paddingLeft: '0px !important',
    paddingRight: '0px !important',
    flexDirection: 'row',
    [(0, _eui.useEuiBreakpoint)(['xs', 's', 'm', 'l'])]: {
      padding: 0
    }
  });
  const dvSearchPanelContainer = (0, _react2.css)({
    alignItems: 'baseline',
    [(0, _eui.useEuiBreakpoint)(['xs', 's', 'm', 'l'])]: {
      flexDirection: 'column'
    }
  });
  const dvSearchBar = (0, _react2.css)({
    [(0, _eui.useEuiBreakpoint)(['xs', 's', 'm', 'l'])]: {
      minWidth: `max(100%, 300px)`
    }
  });
  const isWithinXl = (0, _eui.useIsWithinMaxBreakpoint)('xl');
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    "data-test-subj": "dataVisualizerSearchPanel",
    css: dvSearchPanelContainer,
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 9,
    css: dvSearchBar
  }, /*#__PURE__*/_react.default.createElement(SearchBar, {
    dataTestSubj: "dataVisualizerQueryInput",
    appName: 'dataVisualizer',
    showFilterBar: true,
    showDatePicker: false,
    showQueryInput: true,
    query: searchInput,
    onQuerySubmit: params => searchHandler({
      query: params.query
    }),
    onFiltersUpdated: filters => searchHandler({
      filters
    }),
    indexPatterns: [dataView],
    placeholder: _i18n.i18n.translate('xpack.dataVisualizer.searchPanel.queryBarPlaceholderText', {
      defaultMessage: 'Search… (e.g. status:200 AND extension:"PHP")'
    }),
    displayStyle: 'inPage',
    isClearable: true,
    customSubmitButton: /*#__PURE__*/_react.default.createElement("div", null)
  })), isWithinXl ? /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 2,
    css: dvSearchPanelControls
  }, /*#__PURE__*/_react.default.createElement(_field_name_filter.DataVisualizerFieldNamesFilter, {
    overallStats: overallStats,
    setVisibleFieldNames: setVisibleFieldNames,
    visibleFieldNames: visibleFieldNames,
    showEmptyFields: showEmptyFields
  }), /*#__PURE__*/_react.default.createElement(_field_type_filter.DataVisualizerFieldTypeFilter, {
    indexedFieldTypes: indexedFieldTypes,
    setVisibleFieldTypes: setVisibleFieldTypes,
    visibleFieldTypes: visibleFieldTypes
  })));
};
exports.SearchPanel = SearchPanel;