"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TopValues = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _classnames = _interopRequireDefault(require("classnames"));
var _i18n = require("@kbn/i18n");
var _fieldTypes = require("@kbn/field-types");
var _react2 = require("@emotion/react");
var _mlNumberUtils = require("@kbn/ml-number-utils");
var _kibana_context = require("../../../kibana_context");
var _utils = require("../utils");
var _expanded_row_field_header = require("../stats_table/components/expanded_row_field_header");
var _expanded_row_panel = require("../stats_table/components/field_data_expanded_row/expanded_row_panel");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getPercentLabel(percent) {
  if (percent >= 0.1) {
    return `${(0, _mlNumberUtils.roundToDecimalPlace)(percent, 1)}%`;
  } else {
    return '< 0.1%';
  }
}
const TopValues = ({
  stats,
  fieldFormat,
  barColor,
  compressed,
  onAddFilter
}) => {
  var _ref, _stats$totalDocuments;
  const {
    services: {
      data: {
        fieldFormats
      }
    }
  } = (0, _kibana_context.useDataVisualizerKibana)();
  if (stats === undefined || !stats.topValues) return null;
  const {
    topValues,
    fieldName,
    sampleCount
  } = stats;
  if ((topValues === null || topValues === void 0 ? void 0 : topValues.length) === 0) return null;
  const totalDocuments = (_ref = (_stats$totalDocuments = stats.totalDocuments) !== null && _stats$totalDocuments !== void 0 ? _stats$totalDocuments : sampleCount) !== null && _ref !== void 0 ? _ref : 0;
  const topValuesOtherCountPercent = 1 - (topValues ? topValues.reduce((acc, bucket) => acc + bucket.percent, 0) : 0);
  const topValuesOtherCount = Math.floor(topValuesOtherCountPercent * (sampleCount !== null && sampleCount !== void 0 ? sampleCount : 0));
  const countsElement = /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "xs"
  }, totalDocuments > (sampleCount !== null && sampleCount !== void 0 ? sampleCount : 0) ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.dataVisualizer.dataGrid.field.topValues.calculatedFromSampleRecordsLabel",
    defaultMessage: "Calculated from {sampledDocumentsFormatted} sample {sampledDocuments, plural, one {record} other {records}}.",
    values: {
      sampledDocuments: sampleCount,
      sampledDocumentsFormatted: /*#__PURE__*/_react.default.createElement("strong", null, fieldFormats.getDefaultInstance(_fieldTypes.KBN_FIELD_TYPES.NUMBER, [_fieldTypes.ES_FIELD_TYPES.INTEGER]).convert(sampleCount))
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.dataVisualizer.dataGrid.field.topValues.calculatedFromTotalRecordsLabel",
    defaultMessage: "Calculated from {totalDocumentsFormatted} {totalDocuments, plural, one {record} other {records}}.",
    values: {
      totalDocuments,
      totalDocumentsFormatted: /*#__PURE__*/_react.default.createElement("strong", null, fieldFormats.getDefaultInstance(_fieldTypes.KBN_FIELD_TYPES.NUMBER, [_fieldTypes.ES_FIELD_TYPES.INTEGER]).convert(totalDocuments !== null && totalDocuments !== void 0 ? totalDocuments : 0))
    }
  }));
  return /*#__PURE__*/_react.default.createElement(_expanded_row_panel.ExpandedRowPanel, {
    dataTestSubj: 'dataVisualizerFieldDataTopValues',
    className: (0, _classnames.default)('dvPanel__wrapper', compressed ? 'dvPanel--compressed' : undefined)
  }, /*#__PURE__*/_react.default.createElement(_expanded_row_field_header.ExpandedRowFieldHeader, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.dataVisualizer.dataGrid.field.topValuesLabel",
    defaultMessage: "Top values"
  })), /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "dataVisualizerFieldDataTopValuesContent",
    className: (0, _classnames.default)('fieldDataTopValuesContainer', 'dvTopValues__wrapper')
  }, Array.isArray(topValues) ? topValues.map(value => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    alignItems: "center",
    key: value.key
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "dataVisualizerFieldDataTopValueBar"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    value: value.percent,
    max: 1,
    color: barColor,
    size: "xs",
    label: (0, _utils.kibanaFieldFormat)(value.key, fieldFormat),
    className: (0, _classnames.default)('eui-textTruncate', 'topValuesValueLabelContainer'),
    valueText: `${value.doc_count}${totalDocuments !== undefined ? ` (${getPercentLabel(value.percent * 100)})` : ''}`
  })), fieldName !== undefined && value.key !== undefined && onAddFilter !== undefined ? /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)`
                      width: 48px;
                    `
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconSize: "s",
    iconType: "plusInCircle",
    onClick: () => onAddFilter(fieldName, typeof value.key === 'number' ? value.key.toString() : value.key, '+'),
    "aria-label": _i18n.i18n.translate('xpack.dataVisualizer.dataGrid.field.addFilterAriaLabel', {
      defaultMessage: 'Filter for {fieldName}: "{value}"',
      values: {
        fieldName,
        value: value.key
      }
    }),
    "data-test-subj": `dvFieldDataTopValuesAddFilterButton-${value.key}-${value.key}`,
    style: {
      minHeight: 'auto',
      minWidth: 'auto',
      paddingRight: 2,
      paddingLeft: 2,
      paddingTop: 0,
      paddingBottom: 0
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconSize: "s",
    iconType: "minusInCircle",
    onClick: () => onAddFilter(fieldName, typeof value.key === 'number' ? value.key.toString() : value.key, '-'),
    "aria-label": _i18n.i18n.translate('xpack.dataVisualizer.dataGrid.field.removeFilterAriaLabel', {
      defaultMessage: 'Filter out {fieldName}: "{value}"',
      values: {
        fieldName,
        value: value.key
      }
    }),
    "data-test-subj": `dvFieldDataTopValuesExcludeFilterButton-${value.key}-${value.key}`,
    style: {
      minHeight: 'auto',
      minWidth: 'auto',
      paddingTop: 0,
      paddingBottom: 0,
      paddingRight: 2,
      paddingLeft: 2
    }
  })) : null)) : null, topValuesOtherCount > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    alignItems: "center",
    key: "other"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "dataVisualizerFieldDataTopValueBar"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    value: topValuesOtherCount,
    max: totalDocuments,
    color: barColor,
    size: "xs",
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.dataVisualizer.dataGrid.field.topValuesOtherLabel",
      defaultMessage: "Other"
    }),
    className: (0, _classnames.default)('eui-textTruncate', 'topValuesValueLabelContainer'),
    valueText: `${topValuesOtherCount}${totalDocuments !== undefined ? ` (${getPercentLabel(topValuesOtherCountPercent * 100)})` : ''}`
  })), onAddFilter ? /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)`
                  width: 48px;
                `
  }) : null) : null, /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), countsElement)));
};
exports.TopValues = TopValues;