"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndexBasedNumberContentPreview = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _metric_distribution_chart = require("../metric_distribution_chart");
var _utils = require("../../../utils");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const METRIC_DISTRIBUTION_CHART_WIDTH = 100;
const METRIC_DISTRIBUTION_CHART_HEIGHT = 10;
const IndexBasedNumberContentPreview = ({
  config
}) => {
  const {
    stats,
    fieldFormat,
    fieldName
  } = config;
  const dataTestSubj = `dataVisualizerDataGridChart-${fieldName}`;
  const distributionChartData = (0, _react.useMemo)(() => (0, _metric_distribution_chart.buildChartDataFromStats)(stats === null || stats === void 0 ? void 0 : stats.distribution, METRIC_DISTRIBUTION_CHART_WIDTH), [stats === null || stats === void 0 ? void 0 : stats.distribution]);
  const legendText = (0, _react.useMemo)(() => Array.isArray(distributionChartData) && distributionChartData[0].x !== undefined && distributionChartData[distributionChartData.length - 1].x !== undefined ? {
    min: (0, _utils.formatSingleValue)(distributionChartData[0].x),
    max: (0, _utils.formatSingleValue)(distributionChartData[distributionChartData.length - 1].x)
  } : '', [distributionChartData]);
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": dataTestSubj,
    style: {
      width: '100%'
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "dataGridChart__histogram",
    "data-test-subj": `${dataTestSubj}-histogram`
  }, /*#__PURE__*/_react.default.createElement(_metric_distribution_chart.MetricDistributionChart, {
    width: METRIC_DISTRIBUTION_CHART_WIDTH,
    height: METRIC_DISTRIBUTION_CHART_HEIGHT,
    chartData: distributionChartData,
    fieldFormat: fieldFormat,
    hideXAxis: true
  })), /*#__PURE__*/_react.default.createElement("div", {
    className: 'dataGridChart__legend',
    "data-test-subj": `${dataTestSubj}-legend`
  }, legendText && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: 'row',
    "data-test-subj": `${dataTestSubj}-legend`,
    responsive: false,
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    className: 'dataGridChart__legend',
    style: {
      maxWidth: METRIC_DISTRIBUTION_CHART_WIDTH * 0.75
    }
  }, (0, _utils.kibanaFieldFormat)(legendText.min, fieldFormat)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    className: 'dataGridChart__legend'
  }, (0, _utils.kibanaFieldFormat)(legendText.max, fieldFormat))))));
};
exports.IndexBasedNumberContentPreview = IndexBasedNumberContentPreview;