"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TotalCountHeader = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SIGFIGS_IF_ROUNDING = 3; // Number of sigfigs to use for values < 10

const TotalCountHeader = ({
  totalCount,
  approximate,
  loading
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: {
      flexDirection: 'row'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    "data-test-subj": "dataVisualizerTotalDocCountHeader",
    textAlign: "center"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.dataVisualizer.searchPanel.totalDocCountLabel",
    defaultMessage: "Total documents: {prepend}{strongTotalCount}",
    values: {
      prepend: !loading && approximate ? '~' : '',
      strongTotalCount: loading ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
        size: "s"
      }) : /*#__PURE__*/_react.default.createElement("strong", {
        "data-test-subj": "dataVisualizerTotalDocCount"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.dataVisualizer.searchPanel.totalDocCountNumber",
        defaultMessage: "{totalCount, plural, one {#} other {#}}",
        values: {
          totalCount: approximate ? totalCount.toPrecision(SIGFIGS_IF_ROUNDING) : totalCount
        }
      }))
    }
  })), approximate ? /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    content: _i18n.i18n.translate('xpack.dataVisualizer.searchPanel.randomSamplerMessage', {
      defaultMessage: 'Approximate values are shown in the total document count and chart, which use random sampler aggregations.'
    }),
    position: "right",
    type: "iInCircle"
  }) : null);
};
exports.TotalCountHeader = TotalCountHeader;