"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GeoPointForm = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _utils = require("./utils");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class GeoPointForm extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "onLatFieldChange", e => {
      this.setState({
        latField: e.target.value
      });
    });
    (0, _defineProperty2.default)(this, "onLonFieldChange", e => {
      this.setState({
        lonField: e.target.value
      });
    });
    (0, _defineProperty2.default)(this, "onGeoPointFieldChange", e => {
      const geoPointField = e.target.value;
      this.setState({
        geoPointField
      });
      this.hasNameCollision(geoPointField);
    });
    (0, _defineProperty2.default)(this, "hasNameCollision", (0, _lodash.debounce)(name => {
      try {
        const geoPointFieldError = this.props.hasNameCollision(name) ? (0, _utils.getNameCollisionMsg)(name) : '';
        this.setState({
          geoPointFieldError
        });
      } catch (error) {
        this.setState({
          submitError: error.message
        });
      }
    }, 200));
    (0, _defineProperty2.default)(this, "onSubmit", () => {
      try {
        this.props.addCombinedField((0, _utils.createGeoPointCombinedField)(this.state.latField, this.state.lonField, this.state.geoPointField));
        this.setState({
          submitError: ''
        });
      } catch (error) {
        this.setState({
          submitError: error.message
        });
      }
    });
    const latFields = [{
      value: '',
      text: ''
    }];
    const lonFields = [{
      value: '',
      text: ''
    }];
    (0, _utils.getFieldNames)(props.results).forEach(columnName => {
      if ((0, _utils.isWithinLatRange)(columnName, props.results.field_stats)) {
        latFields.push({
          value: columnName,
          text: columnName
        });
      }
      if ((0, _utils.isWithinLonRange)(columnName, props.results.field_stats)) {
        lonFields.push({
          value: columnName,
          text: columnName
        });
      }
    });
    this.state = {
      latField: '',
      lonField: '',
      geoPointField: '',
      geoPointFieldError: '',
      submitError: '',
      latFields,
      lonFields
    };
  }
  render() {
    let error;
    if (this.state.submitError) {
      error = /*#__PURE__*/_react.default.createElement(_eui.EuiFormErrorText, null, this.state.submitError);
    }
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: _i18n.i18n.translate('xpack.dataVisualizer.file.geoPointForm.latFieldLabel', {
        defaultMessage: 'Latitude field'
      })
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
      options: this.state.latFields,
      value: this.state.latField,
      onChange: this.onLatFieldChange
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: _i18n.i18n.translate('xpack.dataVisualizer.file.geoPointForm.lonFieldLabel', {
        defaultMessage: 'Longitude field'
      })
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
      options: this.state.lonFields,
      value: this.state.lonField,
      onChange: this.onLonFieldChange
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: _i18n.i18n.translate('xpack.dataVisualizer.file.geoPointForm.geoPointFieldLabel', {
        defaultMessage: 'Geo point field'
      }),
      isInvalid: this.state.geoPointFieldError !== '',
      error: [this.state.geoPointFieldError]
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      value: this.state.geoPointField,
      onChange: this.onGeoPointFieldChange,
      isInvalid: this.state.geoPointFieldError !== '',
      "aria-label": _i18n.i18n.translate('xpack.dataVisualizer.file.geoPointForm.geoPointFieldAriaLabel', {
        defaultMessage: 'Geo point field, required field'
      })
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), error, /*#__PURE__*/_react.default.createElement(_eui.EuiTextAlign, {
      textAlign: "right"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      size: "s",
      fill: true,
      disabled: !this.state.latField || !this.state.lonField || !this.state.geoPointField || this.state.geoPointFieldError !== '',
      onClick: this.onSubmit
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.dataVisualizer.file.geoPointForm.submitButtonLabel",
      defaultMessage: "Add"
    }))));
  }
}
exports.GeoPointForm = GeoPointForm;