"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ScriptedFieldsTable = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _scripting_languages = require("../../../scripting_languages");
var _components = require("./components");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class ScriptedFieldsTable extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "fetchFields", async () => {
      const fields = await this.props.indexPattern.getScriptedFields();
      const deprecatedLangsInUse = [];
      const deprecatedLangs = (0, _scripting_languages.getDeprecatedScriptingLanguages)();
      const supportedLangs = (0, _scripting_languages.getSupportedScriptingLanguages)();
      for (const field of fields) {
        const lang = field.lang;
        if (deprecatedLangs.includes(lang) || !supportedLangs.includes(lang)) {
          deprecatedLangsInUse.push(lang);
        }
      }
      this.setState({
        fields,
        deprecatedLangsInUse
      });
    });
    (0, _defineProperty2.default)(this, "getFilteredItems", () => {
      const {
        fields
      } = this.state;
      const {
        fieldFilter,
        scriptedFieldLanguageFilter,
        userEditPermission
      } = this.props;
      let languageFilteredFields = fields;
      if (scriptedFieldLanguageFilter.length) {
        languageFilteredFields = fields.filter(field => scriptedFieldLanguageFilter.includes(field.lang));
      }
      let filteredFields = languageFilteredFields;
      if (fieldFilter) {
        const normalizedFieldFilter = fieldFilter.toLowerCase();
        filteredFields = languageFilteredFields.filter(field => field.name.toLowerCase().includes(normalizedFieldFilter));
      }
      filteredFields.forEach(field => field.isUserEditable = userEditPermission);
      return filteredFields;
    });
    (0, _defineProperty2.default)(this, "startDeleteField", field => {
      this.setState({
        fieldToDelete: field,
        isDeleteConfirmationModalVisible: true
      });
    });
    (0, _defineProperty2.default)(this, "hideDeleteConfirmationModal", () => {
      this.setState({
        fieldToDelete: undefined,
        isDeleteConfirmationModalVisible: false
      });
    });
    (0, _defineProperty2.default)(this, "deleteField", () => {
      const {
        indexPattern,
        onRemoveField,
        saveIndexPattern
      } = this.props;
      const {
        fieldToDelete
      } = this.state;
      indexPattern.removeScriptedField(fieldToDelete.name);
      saveIndexPattern(indexPattern);
      if (onRemoveField) {
        onRemoveField();
      }
      this.fetchFields();
      this.hideDeleteConfirmationModal();
    });
    this.state = {
      deprecatedLangsInUse: [],
      fieldToDelete: undefined,
      isDeleteConfirmationModalVisible: false,
      fields: []
    };
  }
  UNSAFE_componentWillMount() {
    this.fetchFields();
  }
  render() {
    const {
      indexPattern,
      painlessDocLink
    } = this.props;
    const {
      fieldToDelete,
      deprecatedLangsInUse
    } = this.state;
    const items = this.getFilteredItems();
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_components.Header, {
      indexPatternId: indexPattern.id || ''
    }), /*#__PURE__*/_react.default.createElement(_components.CallOuts, {
      deprecatedLangsInUse: deprecatedLangsInUse,
      painlessDocLink: painlessDocLink
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l"
    }), /*#__PURE__*/_react.default.createElement(_components.Table, {
      indexPattern: indexPattern,
      items: items,
      editField: field => this.props.helpers.redirectToRoute(field),
      deleteField: this.startDeleteField
    }), fieldToDelete && /*#__PURE__*/_react.default.createElement(_components.DeleteScritpedFieldConfirmationModal, {
      deleteField: this.deleteField,
      field: fieldToDelete,
      hideDeleteConfirmationModal: this.hideDeleteConfirmationModal
    }));
  }
}
exports.ScriptedFieldsTable = ScriptedFieldsTable;