"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DeleteScritpedFieldConfirmationModal = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const DeleteScritpedFieldConfirmationModal = ({
  field,
  hideDeleteConfirmationModal,
  deleteField
}) => {
  const title = _i18n.i18n.translate('indexPatternManagement.editIndexPattern.scripted.deleteFieldLabel', {
    defaultMessage: "Delete scripted field '{fieldName}'?",
    values: {
      fieldName: field.name
    }
  });
  const cancelButtonText = _i18n.i18n.translate('indexPatternManagement.editIndexPattern.scripted.deleteField.cancelButton', {
    defaultMessage: 'Cancel'
  });
  const confirmButtonText = _i18n.i18n.translate('indexPatternManagement.editIndexPattern.scripted.deleteField.deleteButton', {
    defaultMessage: 'Delete'
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    title: title,
    onCancel: hideDeleteConfirmationModal,
    onConfirm: deleteField,
    cancelButtonText: cancelButtonText,
    confirmButtonText: confirmButtonText,
    defaultFocusedButton: _eui.EUI_MODAL_CONFIRM_BUTTON
  });
};
exports.DeleteScritpedFieldConfirmationModal = DeleteScritpedFieldConfirmationModal;